/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.bean;

import java.sql.Connection;
import java.util.Date;
import java.util.concurrent.Callable;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.subscription.common.bean.Subscription;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionUtils;
import ru.bitel.bgbilling.modules.subscription.server.event.SubscriptionRegistrationPeriodEndEvent;
import ru.bitel.common.ParameterMap;
import ru.bitel.oss.kernel.job.server.JobContext;

public class SubscriptionJob
extends BGLogger
implements Callable<Object> {
    @Override
    public Object call() throws Exception {
        block6: {
            JobContext context = (JobContext)JobContext.get();
            Connection con = context.getConnection();
            ParameterMap params = context.getJobParams();
            while (context.getJobTriggerTime().getTime() > System.currentTimeMillis()) {
                Thread.sleep((context.getJobTriggerTime().getTime() - System.currentTimeMillis()) / 2L);
            }
            int subscriptionId = params.getInt("subscriptionId", -1);
            if (subscriptionId > 0) {
                try {
                    int moduleId = context.getModuleId();
                    SubscriptionDao subscriptionDao = new SubscriptionDao(con, moduleId, 0);
                    Subscription subscription = (Subscription)subscriptionDao.get(subscriptionId);
                    if (subscription == null) {
                        throw new BGException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
                    }
                    EventProcessor.getInstance().publish((Event)new SubscriptionRegistrationPeriodEndEvent(moduleId, subscription.getContractId(), -1, subscription.getId()));
                    if (!subscription.isAvtoCommit()) {
                        throw new BGException("\u041f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0444\u043b\u0430\u0433 \u0430\u0432\u0442\u043e\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d");
                    }
                    new SubscriptionUtils(con).subscriptionActivate(subscription, new Date(), moduleId, 0, subscriptionDao);
                }
                catch (BGException ex) {
                    if (!this.getLogger().isInfoEnabled()) break block6;
                    this.getLogger().info(ex.getLocalizedMessage() + " [subscriptionId = " + subscriptionId + "]");
                }
            }
        }
        return null;
    }
}

