/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class TrayInfoTypeManager
extends AbstarctDaoConstant {
    public TrayInfoTypeManager(Connection con, int moduleId) {
        super(con, "trayinfo_type", moduleId);
    }

    public TrayInfoType getTrayInfoTypeById(int id) throws SQLException {
        TrayInfoType result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = new TrayInfoType();
                    TrayInfoTypeManager.loadTypeFromRS(rs, result);
                }
            }
        }
        return result;
    }

    public List<TrayInfoType> getTrayInfoTypesList(Date date) throws SQLException {
        ArrayList<TrayInfoType> result = new ArrayList<TrayInfoType>();
        String query = "SELECT * FROM " + this.tableName;
        if (date != null) {
            query = query + " WHERE ( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2>=? )";
        }
        query = query + " ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            if (date != null) {
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    TrayInfoType type = new TrayInfoType();
                    result.add(type);
                    TrayInfoTypeManager.loadTypeFromRS(rs, type);
                }
            }
        }
        return result;
    }

    public void deleteTrayInfoType(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public void updateTrayInfoType(TrayInfoType type) throws SQLException {
        boolean update = type.getId() > 0;
        String query = null;
        query = update ? "UPDATE " + this.tableName + " SET title=?, pt=?, cost=?, days=?, date1=?, date2=? WHERE id=?" : "INSERT INTO " + this.tableName + " ( title, pt, cost, days, date1, date2 ) VALUES ( ?, ?, ?, ?, ?, ? )";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, type.getTitle());
            ps.setInt(2, type.getChargeType());
            ps.setBigDecimal(3, type.getCost());
            ps.setFloat(4, type.getDays());
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)type.getDate1()));
            ps.setDate(6, TimeUtils.convertDateToSqlDate((Date)type.getDate2()));
            if (update) {
                ps.setInt(7, type.getId());
            }
            ps.executeUpdate();
            if (!update) {
                type.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    private static void loadTypeFromRS(ResultSet rs, TrayInfoType type) throws SQLException {
        type.setId(rs.getInt("id"));
        type.setTitle(rs.getString("title"));
        type.setChargeType(rs.getInt("pt"));
        type.setCost(rs.getBigDecimal("cost"));
        type.setDate1((Date)rs.getDate("date1"));
        type.setDate2((Date)rs.getDate("date2"));
        type.setDays(rs.getInt("days"));
    }
}

