<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://common.bitel.ru">
	<xsl:import href="layout.xsl" />
	
	<xsl:template name="title">
		Управление подписками
	</xsl:template>
	
	<xsl:template match="/data">
		<div class="report">
			<table class="table800">
				<thead>
					<tr>
						<td>Название подписки</td>
						<td>Статус</td>
						<td>Дата установки статуса</td>
						<td>Количество</td>
						<td>Общая стоимость</td>
						<td>Лицензионный ключ</td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><xsl:value-of select="/data/transaction/optionTitle/text()"/></td>
						<td><xsl:value-of select="/data/transaction/statusTitle/text()"/></td>
						<td><xsl:value-of select="/data/transaction/stringDt/text()"/></td>
						<td><xsl:value-of select="/data/transaction/subscribeCount/text()"/></td>
						<td><xsl:value-of select="/data/transaction/subscribeAmount/text()"/></td>
						<td><xsl:value-of select="/data/transaction/key/text()"/></td>
					</tr>
				</tbody>
				<tfoot>
					<xsl:variable name="status"><xsl:value-of select="/data/transaction/status/text()" /></xsl:variable>
					<tr>
						<td colspan="3" />
						<td>
							<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
								<xsl:call-template name="action"/>
								<input type="hidden" name="optionId">
										<xsl:attribute name="value"><xsl:value-of select="/data/transaction/optionId/text()"/></xsl:attribute>
								</input>
								<input type="hidden" name="operation" value="pauseSubscription"/>
								
								<button id="_pause" class="gradbtn blue" type="button" onClick="submitButtonOnce( this );" >
									<xsl:if test="$status=0 or $status=2 or $status=3">
										<xsl:attribute name="disabled">disabled</xsl:attribute>										
									</xsl:if>
									Приостановить
								</button>
							</form>
						</td>
						<td>
							<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
								<xsl:call-template name="action"/>
								<input type="hidden" name="optionId">
										<xsl:attribute name="value"><xsl:value-of select="/data/transaction/optionId/text()"/></xsl:attribute>
								</input>
								<input type="hidden" name="operation" value="continueSubscription"/>
								
								<button id="_continue" class="gradbtn blue" type="button" onClick="submitButtonOnce( this );">
									<xsl:if test="$status=0 or $status=1 or $status=3">
										<xsl:attribute name="disabled">disabled</xsl:attribute>										
									</xsl:if>
									Возобновить
								</button>
							</form>
						</td>
						<td>
							<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
								<xsl:call-template name="action"/>
								<input type="hidden" name="optionId">
										<xsl:attribute name="value"><xsl:value-of select="/data/transaction/optionId/text()"/></xsl:attribute>
								</input>
								<input type="hidden" name="operation" value="stopSubscription"/>
								
								<button id="_stop" class="gradbtn blue" type="button" onClick="submitButtonOnce( this );">
									<xsl:if test="$status=0 or $status=3">
										<xsl:attribute name="disabled">disabled</xsl:attribute>										
									</xsl:if>
									Остановить
								</button>
							</form>
						</td>
					</tr>
				</tfoot>
			</table>
		</div>
		<br/>
		История изменения статуса
		<br/>		
		<div class="rpeort">
			<table class="table800">
				<thead>
					<tr>
						<td>Дата</td>
						<td>Статус</td>
					</tr>
				</thead>
				<tbody>
					<xsl:for-each select="transactionLog/data/item">
						<tr>
							<td><xsl:value-of select="logDate"/></td>
							<td><xsl:value-of select="status"/></td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
		</div>
		<br/>
		Доступные подписки
		<br/>
		<div class="rpeort">
			<table class="table800">
				<form method="POST" action="{$WEBEXECUTER}">
					<xsl:call-template name="module"/>
					<xsl:call-template name="action"/>
					<input type="hidden" name="operation" value="activateSubscription"/>
					<thead>
						<tr>
							<td></td>
							<td>Название подписки</td>
							<td>Описание продукта</td>
							<td>Стоимость подписки за 1 день</td>
						</tr>
					</thead>
					<tbody>
						<xsl:for-each select="productList/data/item">
							<tr>
								<td> <input type="radio" name="optionId"><xsl:attribute name="value"><xsl:value-of select="subscribeId/text()"/></xsl:attribute></input></td>
								<td><xsl:value-of select="subscribeName"/></td>
								<td><xsl:value-of select="productDescription"/></td>
								<td><xsl:value-of select="amount"/></td>
							</tr>
						</xsl:for-each>
					</tbody>
					<tfoot>
						<tr>
							<td colspan="4" style="text-align: right;">
								<input type="submit" class="gradbtn blue" value="Активировать"/>
							</td>
						</tr>
					</tfoot>
				</form>
			</table>
		</div>
	</xsl:template>
	
</xsl:stylesheet>
