/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.xsl.server.worker;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.oss.kernel.xsl.common.bean.XslPattern;
import ru.bitel.oss.kernel.xsl.common.event.XslModifiedEvent;
import ru.bitel.oss.kernel.xsl.server.bean.XslPatternDao;
import ru.bitel.oss.kernel.xsl.server.bean.XslPatternRuntime;
import ru.bitel.oss.kernel.xsl.server.bean.XslPatternRuntimeMap;

public class XslPatterWorker
extends Thread {
    private boolean run = true;
    private XslPatternRuntimeMap xslPatternRuntimeMap = null;
    private long checkPeriod = Setup.getSetup().getLong("xslt.cache.check.period", 900L) * 1000L;

    public XslPatterWorker() {
        this.setDaemon(true);
        try {
            EventProcessor.getInstance().addListener(new EventListener<ModuleConfigModifiedEvent>(){

                @Override
                public void notify(ModuleConfigModifiedEvent event, EventListenerContext ctx) throws Exception {
                    if (event.getModuleId() == 0) {
                        XslPatterWorker.this.checkPeriod = Setup.getSetup().getLong("xslt.cache.check.period", 900L) * 1000L;
                    }
                }
            }, ModuleConfigModifiedEvent.class);
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        try {
            this.xslPatternRuntimeMap = XslPatternRuntimeMap.getInstance();
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
    }

    @Override
    public void run() {
        while (this.run) {
            block14: {
                try {
                    Path xslPath = Path.of(".", "webroot", "xsl");
                    if (Files.exists(xslPath, new LinkOption[0]) && Files.isDirectory(xslPath, new LinkOption[0])) {
                        List<XslFile> fileNames = Files.walk(xslPath.toAbsolutePath(), new FileVisitOption[0]).filter(a -> a.toString().endsWith(".xsl")).map(XslFile::new).toList();
                        Map<String, XslPatternRuntime> map = this.xslPatternRuntimeMap.getMap();
                        List<XslFile> updateFileNames = fileNames.parallelStream().filter(a -> !map.containsKey(a.getName()) || a.getUpdateTime() != ((XslPatternRuntime)map.get(a.getName())).getUpdateTime()).toList();
                        List<String> deleteFileNames = map.keySet().parallelStream().filter(a -> fileNames.stream().filter(b -> b.getName().equals(a)).count() == 0L).toList();
                        if (updateFileNames.isEmpty() && deleteFileNames.isEmpty()) break block14;
                        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                            XslPatternDao xslPatternDao = new XslPatternDao(con);
                            for (XslFile xslFile : updateFileNames) {
                                xslPatternDao.update(xslFile.toXslPattern());
                            }
                            for (String name : deleteFileNames) {
                                xslPatternDao.delete(name);
                            }
                        }
                        EventProcessor.getInstance().publish((Event)new XslModifiedEvent(0));
                        break block14;
                    }
                    BGLogger.error("xslPath = " + xslPath.toString() + " not found");
                    this.run = false;
                }
                catch (Exception ex) {
                    BGLogger.error(ex);
                }
            }
            try {
                XslPatterWorker.sleep(this.checkPeriod);
            }
            catch (InterruptedException ex) {
                BGLogger.error(ex);
            }
        }
    }

    static class XslFile {
        private Path path;
        private String name;
        private long updateTime;

        XslFile(Path path) {
            this.path = path;
            this.name = path.getFileName().toString();
            try {
                this.updateTime = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
        }

        public String getName() {
            return this.name;
        }

        public long getUpdateTime() {
            return this.updateTime;
        }

        public XslPattern toXslPattern() {
            try {
                return new XslPattern().setName(this.name).setUpdateTime(this.updateTime).setData(Files.readString(this.path));
            }
            catch (Exception ex) {
                BGLogger.error(this.path.toString() + " " + ex.toString());
                return null;
            }
        }
    }
}

