/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.table;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.card.common.bean.CardFilter;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.CardDao;
import ru.bitel.bgbilling.modules.card.server.bean.DealerDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TableCardManager
extends BGTableInfoBase {
    public TableCardManager() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextCenter((String)"\u041d\u043e\u043c\u0435\u0440", (String)"number").setWidth(120), BGUTableColumn.buildColumnTextCenter((String)"\u041b\u043e\u0433\u0438\u043d", (String)"login").setMaxWidth(80), BGUTableColumn.buildColumnTextCenter((String)"\u041f\u0430\u0440\u043e\u043b\u044c", (String)"pswd").setMaxWidth(120), BGUTableColumn.buildColumnPeriod(), BGUTableColumn.buildColumnTextLeft((String)"\u0414\u0438\u043b\u0435\u0440", (String)"dealerTitle").setWidth(-1), BGUTableColumn.buildColumnTextCenter((String)"\u0421\u0442\u0430\u0442\u0443\u0441", (String)"status").setWidth(80), BGUTableColumn.buildColumnTextRight((String)"\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", (String)"cost").setWidth(100), BGUTableColumn.buildColumnTextCenter((String)"\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438", (String)"dateTransfers").setWidth(120), BGUTableColumn.buildColumnTextCenter((String)"\u0414\u0430\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", (String)"dateActivated").setWidth(150), BGUTableColumn.buildColumnTextCenter((String)"\u0414\u043e\u0433\u043e\u0432\u043e\u0440", (String)"contractTitle").setWidth(150)};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext context = this.getContext();
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        String[] statusTitle = new String[]{moduleSetup.get("status.title.lock", "Lock"), moduleSetup.get("status.title.pay", "Pay"), moduleSetup.get("status.title.contract", "Contract"), moduleSetup.get("status.title.balance", "Balance")};
        long num = -1L;
        long count = 0L;
        String numCount = tableParams.optParamValue("numCount").orElse("");
        if (numCount.indexOf("+") > 0) {
            StringTokenizer st = new StringTokenizer(numCount, "+");
            if (st.hasMoreTokens()) {
                num = Utils.parseLong((String)st.nextToken(), (long)-1L);
            }
            if (st.hasMoreTokens()) {
                count = Utils.parseLong((String)st.nextToken(), (long)1L);
            }
        } else {
            num = Utils.parseLong((String)numCount, (long)-1L);
        }
        CardFilter cardFilter = new CardFilter().setDealerId(Utils.parseInt((String)tableParams.get("dealerId"))).setCardCode(tableParams.optParamValue("login").map(a -> Utils.parseLong((String)a)).orElse(0L).longValue()).setCardPin((String)tableParams.optParamValue("pass").filter(a -> Utils.notBlankString((String)a)).orElse(null)).setSumFrom((BigDecimal)tableParams.optParamValue("sumFrom").map(a -> Utils.parseBigDecimal((String)a, null)).orElse(null)).setSumTo((BigDecimal)tableParams.optParamValue("sumTo").map(a -> Utils.parseBigDecimal((String)a, null)).orElse(null)).setStatusIds((List)tableParams.optParamValue("statusIds").map(a -> Utils.toIntegerList((String)a)).orElse(null)).setDateType((String)tableParams.optParamValue("dateType").orElse(null)).setPeriod(tableParams.getPeriod()).setIdFrom(num).setIdCount(count);
        SearchResult searchResult = new SearchResult(tableParams.getPage());
        new CardDao(context.getConnection(), moduleId).searchCards((SearchResult<Card>)searchResult, cardFilter);
        this.page = tableParams.getPage();
        this.addAttribute("totalSum", Optional.ofNullable(searchResult.getSum()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN).toPlainString());
        List<Integer> contractIds = searchResult.getList().stream().filter(a -> a.getContractId() > 0).map(a -> a.getContractId()).toList();
        List<Integer> dealerIds = searchResult.getList().stream().filter(a -> a.getDealerId() > 0).map(a -> a.getDealerId()).toList();
        Map contractTitleMap = ContractDao.getContractTitles((Connection)context.getConnection(), contractIds);
        Map<Integer, String> dealerTitleMap = new DealerDao(context.getConnection(), moduleId).getDealerTitles(dealerIds);
        return searchResult.getList().stream().map(a -> new BGUTableRowData().addValue("number", String.valueOf(a.getId())).addValue("login", String.valueOf(a.getCardCode())).addValue("pswd", a.getCardPinCode()).addValue("cost", Utils.formatCost((float)a.getSumma())).addValue("status", statusTitle[a.getStatus()]).addValue(this.getPeriod(new Period(a.getDateBegin(), a.getDateEnd()))).addValue("dateTransfers", TimeUtils.formatDate((Date)a.getDealerDate())).addValue("dateActivated", TimeUtils.format((Date)a.getDateActivate(), (String)"dd.MM.yyyy")).addValue("dealerTitle", dealerTitleMap.getOrDefault(a.getDealerId(), "")).addValue("contractTitle", contractTitleMap.getOrDefault(a.getContractId(), "")).addValue("contractId", a.getContractId())).toList();
    }
}

