/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UnregRequestRecord;
import ru.bitel.bgbilling.kernel.bgsecure.server.UserActionRecorderCache;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.RoleDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserRecordLogDao;
import ru.bitel.bgbilling.kernel.container.security.server.AbstractPermissionChecker;
import ru.bitel.bgbilling.kernel.container.security.server.CheckPermissionKitToAllowAction;
import ru.bitel.bgbilling.kernel.container.security.server.CheckPermissionKitToAllowContract;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.common.event.PermissionKitUpdateEvent;
import ru.bitel.bgbilling.kernel.module.common.event.RoleUpdateEvent;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.kernel.directories.domain.common.event.DomainModifiedEvent;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;

public class PermissionOfRoles
extends AbstractPermissionChecker {
    private static final String PERMISSION_DISABLE_KEY = "bgsecure.checker.disable";
    private static final List<String> PARAMETER_UPDATE_OPERATIONS = Arrays.asList("contractParameterUpdate", "contractParameterTextUpdate", "contractParameterDateUpdate", "contractParameterBooleanUpdate", "contractParameterPhoneUpdate", "contractParameterListUpdate", "contractParameterIntUpdate", "contractParameterAddressUpdate", "contractParameterEmailUpdate", "contractParameterContractUpdate", "contractParameterMultiListUpdate");
    private static boolean permissionCheckerDisabled = false;
    private static final Map<Integer, User> usersById = new ConcurrentHashMap<Integer, User>();
    private static Map<Integer, Role> userWithRole = new ConcurrentHashMap<Integer, Role>();
    private final Map<Integer, List<PermissionKit>> permissionKitsOfRole = new ConcurrentHashMap<Integer, List<PermissionKit>>();
    private static final Map<Integer, List<Integer>> contractLabels = new HashMap<Integer, List<Integer>>();
    private static final PermissionOfRoles instance = new PermissionOfRoles();

    public static PermissionOfRoles getInstance() {
        return instance;
    }

    private PermissionOfRoles() {
        super(Setup.getSetup());
        permissionCheckerDisabled = this.setup.getBoolean(PERMISSION_DISABLE_KEY, false);
        if (permissionCheckerDisabled) {
            this.getLogger().warn("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u041e\u0422\u041a\u041b\u042e\u0427\u0415\u041d\u0410!");
        }
        this.addCheckerAsListener();
        this.reloadUserRoles();
        this.loadContractLabels();
    }

    private void addCheckerAsListener() {
        try {
            EventProcessor eventProcessor = EventProcessor.getInstance();
            eventProcessor.addListener((e, ctx) -> this.reloadUserRoles(), ModulesChangedEvent.class);
            eventProcessor.addListener((e, ctx) -> {
                this.reloadUserRoles();
                int roleId = e.getRoleId();
                if (roleId > 0) {
                    this.permissionKitsOfRole.remove(roleId);
                } else {
                    this.permissionKitsOfRole.clear();
                }
            }, RoleUpdateEvent.class);
            eventProcessor.addListener((e, ctx) -> {
                int contractId = e.getContractId();
                if (contractId > 0) {
                    try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                        contractLabels.put(contractId, new ContractLabelManager(con).getContractLabelIds(contractId));
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
            }, ContractModifiedEvent.class);
            eventProcessor.addListener((e, ctx) -> {
                this.reloadUserRoles();
                if (Utils.notEmptyCollection(e.getRolesWithKit())) {
                    e.getRolesWithKit().forEach(this.permissionKitsOfRole::remove);
                } else {
                    this.permissionKitsOfRole.clear();
                }
            }, PermissionKitUpdateEvent.class);
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
                DomainRuntimeMap.getInstance(connectionSet);
            }
            eventProcessor.addListener((e, ctx) -> this.reloadUserRoles(), DomainModifiedEvent.class);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public synchronized void reloadUserRoles() {
        this.getLogger().info("Reload user roles");
        try (Connection connection = Setup.getSetup().getDBConnectionFromPool();){
            RoleDao roleDao = new RoleDao(connection);
            UserManager userManager = new UserManager(connection);
            HashMap<Integer, Role> userRoleMap = new HashMap<Integer, Role>();
            List<User> users = userManager.list();
            this.getLogger().info("All users count = " + users.size());
            usersById.clear();
            users.forEach(user -> usersById.put(user.getId(), (User)((Object)user)));
            List<Role> roles = roleDao.list(null, null, new Object[0]);
            this.getLogger().info("All roles loaded = " + roles.size());
            Map roleMap = roles.stream().collect(Collectors.toMap(Id::getId, Function.identity()));
            for (User user2 : users) {
                userRoleMap.put(user2.getId(), (Role)((Object)roleMap.get(user2.getRoleId())));
            }
            userWithRole = userRoleMap;
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void loadContractLabels() {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            contractLabels.clear();
            contractLabels.putAll(new ContractLabelManager(con).getContractListWithLabels());
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public String checkActionAllow(HttpServletRequest req, String moduleId, ModuleAction moduleAction, int userId, int cid) {
        return this.checkActionAllow(this.getRequestMap(req), moduleId, moduleAction, userId, cid);
    }

    public String checkActionAllow(Map<String, String> requestMap, String moduleId, ModuleAction moduleAction, int userId, int contractId) {
        if (PermissionOfRoles.isAdmin(userId) || permissionCheckerDisabled) {
            return null;
        }
        if (moduleAction == null) {
            String action = requestMap.get("action");
            this.getLogger().debug("Action " + action + " not found in dictionary for module " + moduleId);
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                new UserRecordLogDao(con).update(new UnregRequestRecord().setLastTime(LocalDateTime.now()).setAction(action).setModuleId(moduleId).setContractId(contractId).setUserId(userId));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            return null;
        }
        try {
            String action = requestMap.get("action");
            int pid = Utils.parseInt((String)requestMap.get("pid"), (int)-1);
            int opid = Utils.parseInt((String)requestMap.get("param"), (int)-1);
            this.checkActionAllow(userId, moduleId, moduleAction, action, null, contractId, pid, opid);
        }
        catch (BGIllegalAccessException ex) {
            return ex.getMessage();
        }
        return null;
    }

    public void checkActionAllow(int userId, String moduleId, ModuleAction moduleAction, String service, String operation, int contractId, Map<String, Object> params) throws BGIllegalAccessException {
        if (PermissionOfRoles.isAdmin(userId) || permissionCheckerDisabled) {
            return;
        }
        if (moduleAction == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Action {}:{} not found in dictionary for module {}", new Object[]{service, operation, moduleId});
            }
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                new UserRecordLogDao(con).update(new UnregRequestRecord().setLastTime(LocalDateTime.now()).setModuleId(moduleId).setService(service).setOperation(operation).setContractId(contractId).setUserId(userId));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            return;
        }
        int pid = 0;
        if (params != null) {
            if ("ContractService".equals(service) && PARAMETER_UPDATE_OPERATIONS.contains(operation)) {
                EntityAttr parameter = (EntityAttr)params.get("parameter");
                if (parameter != null) {
                    pid = parameter.getEntitySpecAttrId();
                }
            } else {
                Object pidObj = params.get("pid");
                if (pidObj instanceof Integer) {
                    pid = (Integer)pidObj;
                }
            }
        }
        this.checkActionAllow(userId, moduleId, moduleAction, service, operation, contractId, pid, 0);
    }

    private void checkActionAllow(int userId, String moduleId, ModuleAction moduleAction, String service, String operation, int contractId, int pid, int opid) throws BGIllegalAccessException {
        Optional<Role> roleOpt = PermissionOfRoles.getRoleByUserId(userId);
        if (roleOpt.isEmpty()) {
            throw new BGIllegalAccessException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u0430\u044f \u0420\u043e\u043b\u044c \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f ID=" + userId);
        }
        Role role = roleOpt.get();
        List<PermissionKit> permissionKits = this.permissionKitsOfRole.get(role.getId());
        if (Utils.isEmptyCollection(permissionKits)) {
            permissionKits = this.getPermissionKitsOfRole(role);
        }
        if (Utils.isEmptyCollection(permissionKits)) {
            throw new BGIllegalAccessException("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d \u043d\u0430\u0431\u043e\u0440 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0440\u043e\u043b\u0438 ID=" + role.getId());
        }
        this.permissionKitsOfRole.put(role.getId(), permissionKits);
        if (contractId > 0) {
            if (PermissionOfRoles.userIsAgent(usersById.get(userId)) && this.isContractDisallowForAgent(contractId, userId)) {
                throw new BGIllegalAccessException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0441 \u044d\u0442\u0438\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c!");
            }
            if (Utils.isEmptyCollection(permissionKits = CheckPermissionKitToAllowContract.checkAllowContract(permissionKits, contractId))) {
                throw new BGIllegalAccessException("\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0430\u0434 \u044d\u0442\u0438\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c!");
            }
        }
        if (!this.checkAllow(permissionKits, moduleId, moduleAction, service, operation, pid, opid, userId)) {
            throw new BGIllegalAccessException("[UserID #" + userId + "] \u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \"" + this.modulePluginMap.get(moduleId) + ": " + moduleAction.title + "\" \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!");
        }
    }

    private boolean isContractDisallowForAgent(int contractId, int userId) {
        boolean isDisallow = true;
        User user = usersById.get(userId);
        if (user == null || user.getContractPid() <= 0 || user.getContractCid() <= 0) {
            isDisallow = false;
            return isDisallow;
        }
        String query = "SELECT cid FROM contract_parameter_type_8 WHERE cid=? AND pid=? AND val=?";
        try (Connection connection = Setup.getSetup().getDBConnectionFromPool();
             PreparedStatement ps = connection.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, user.getContractPid());
            ps.setInt(3, user.getContractCid());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    isDisallow = false;
                }
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
        return isDisallow;
    }

    public static boolean userIsAgent(User user) {
        return user != null && user.getContractCid() > 0 && user.getContractPid() > 0;
    }

    private List<PermissionKit> getPermissionKitsOfRole(Role role) {
        ArrayList<PermissionKit> permissionKits = new ArrayList<PermissionKit>();
        if (role == null) {
            return permissionKits;
        }
        if (Utils.notEmptyCollection(role.getPermissionKits())) {
            permissionKits.addAll(role.getPermissionKits());
        }
        if (Utils.notEmptyCollection(role.getChildren())) {
            for (Role childRole : role.getChildren()) {
                permissionKits.addAll(this.getPermissionKitsOfRole(childRole));
            }
        }
        return permissionKits;
    }

    private boolean checkAllow(List<PermissionKit> permissionKits, String moduleId, ModuleAction moduleAction, String service, String operation, int pid, int opid, int userId) {
        boolean isAllow = false;
        UserActionRecorderCache.getInstance().recIfEnable(userId, moduleId, service, operation, moduleAction.title, moduleAction.getId());
        for (PermissionKit kit : permissionKits) {
            boolean checkContractAllow = CheckPermissionKitToAllowContract.check(pid, opid, userId);
            boolean checkAllowAction = CheckPermissionKitToAllowAction.check(kit, moduleId, moduleAction);
            isAllow = checkAllowAction && checkContractAllow;
            if (!isAllow) continue;
            break;
        }
        return isAllow;
    }

    public static boolean checkReadObjectParameter(int objectId, int userId) {
        boolean parameterAllowed = true;
        Optional<Role> role = PermissionOfRoles.getRoleByUserId(userId);
        if (role.isEmpty()) {
            return true;
        }
        for (PermissionKit kit : role.get().getPermissionKits()) {
            int read = PermissionOfRoles.getReadRule(kit.getContractObjects(), objectId);
            if (read == 0) {
                read = Setup.getSetup().getInt("object.parameter.rule.read.user", 1);
            }
            if (read == 1) {
                parameterAllowed = true;
            } else if (read == 2) {
                parameterAllowed = false;
            }
            if (!parameterAllowed) continue;
            break;
        }
        return parameterAllowed;
    }

    public static boolean checkWriteObjectParameter(int objectId, int userId) {
        boolean parameterAllowed = true;
        Optional<Role> role = PermissionOfRoles.getRoleByUserId(userId);
        if (role.isEmpty()) {
            return true;
        }
        for (PermissionKit kit : role.get().getPermissionKits()) {
            int read = PermissionOfRoles.getWriteRule(kit.getContractObjects(), objectId);
            if (read == 0) {
                read = Setup.getSetup().getInt("object.parameter.rule.read.user", 1);
            }
            if (read == 1) {
                parameterAllowed = true;
            } else if (read == 2) {
                parameterAllowed = false;
            }
            if (!parameterAllowed) continue;
            break;
        }
        return parameterAllowed;
    }

    public static boolean checkReadContractParameter(int pid, int userId) {
        if (PermissionOfRoles.isAdmin(userId) || permissionCheckerDisabled) {
            return true;
        }
        Optional<Role> role = PermissionOfRoles.getRoleByUserId(userId);
        if (role.isEmpty()) {
            return true;
        }
        boolean parameterAllowed = true;
        for (PermissionKit kit : role.get().getPermissionKits()) {
            int read = PermissionOfRoles.getReadRule(kit.getPids(), pid);
            if (read == 0) {
                read = Setup.getSetup().getInt("contract.parameter.rule.read.user", 1);
            }
            if (read == 1) {
                parameterAllowed = true;
            } else if (read == 2) {
                parameterAllowed = false;
            }
            if (!parameterAllowed) continue;
            break;
        }
        return parameterAllowed;
    }

    public static boolean checkWriteContractParameter(int parameterId, int userId) {
        if (PermissionOfRoles.isAdmin(userId) || permissionCheckerDisabled) {
            return true;
        }
        Optional<Role> role = PermissionOfRoles.getRoleByUserId(userId);
        if (role.isEmpty()) {
            return false;
        }
        boolean parameterAllowed = false;
        for (PermissionKit kit : role.get().getPermissionKits()) {
            int write = PermissionOfRoles.getWriteRule(kit.getPids(), parameterId);
            if (write == 0) {
                write = Setup.getSetup().getInt("contract.parameter.rule.write.user", 1);
            }
            if (write == 1) {
                parameterAllowed = true;
            }
            if (!parameterAllowed) continue;
            break;
        }
        return parameterAllowed;
    }

    public Map<Integer, List<Integer>> getContractLabelsMap() {
        return contractLabels;
    }

    public static Optional<Role> getRoleByUser(User user) {
        if (user == null) {
            return Optional.empty();
        }
        return PermissionOfRoles.getRoleByUserId(user.getId());
    }

    public static Optional<Role> getRoleByUserId(int userId) {
        return Optional.ofNullable(userWithRole.get(userId));
    }

    public static Optional<User> getUserById(int userId) {
        return Optional.ofNullable(usersById.get(userId));
    }

    public static boolean isPermissionCheckerDisabled() {
        return permissionCheckerDisabled;
    }

    public static Set<Integer> getDomainsByUser(User user) throws BGException {
        return PermissionOfRoles.getPermissionKitsByUser(user).stream().map(PermissionKit::getDomenIds).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static List<PermissionKit> getPermissionKitsByUser(User user) throws BGException {
        Optional<Role> role = PermissionOfRoles.getRoleByUser(user);
        if (role.isEmpty()) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0440\u043e\u043b\u044c \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        }
        return role.get().getPermissionKits();
    }

    public static Set<Integer> getDomainsByUserId(int userId) throws BGException {
        Optional<User> user = PermissionOfRoles.getUserById(userId);
        if (user.isEmpty()) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0434\u043b\u044f ID = " + userId);
        }
        return PermissionOfRoles.getDomainsByUser(user.get());
    }
}

