/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softkey.server.bean;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

public class SoftkeyParams {
    public static final String SOFTKEY_SERVER_URL = "http://www.softkey.ua/ext_service/query.php";
    private ModuleSetup moduleSetup = null;
    private int ac = -1;
    private String password = null;
    private String webMenuTitle = null;
    private String publicSKkeyFilePath = null;
    private String privatekeyFilePath = null;
    private String publickeyFilePath = null;
    private int chargeTypeId = -1;
    private int maxSubscribeCount = -1;
    private int fioPid = -1;
    private int emailPid = -1;

    public SoftkeyParams(ModuleSetup moduleSetup) {
        this.moduleSetup = moduleSetup;
        this.init();
    }

    private void init() {
        this.ac = this.moduleSetup.getInt("softkey.ac", -1);
        this.password = this.moduleSetup.get("softkey.password", null);
        this.webMenuTitle = this.moduleSetup.get("webMenu", "\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 \u0410\u043d\u0442\u0438\u0432\u0438\u0440\u0443\u0441 \u041a\u0430\u0441\u043f\u0435\u0440\u0441\u043a\u043e\u0433\u043e");
        this.publicSKkeyFilePath = this.moduleSetup.get("softkey.publickey.file.path", null);
        this.privatekeyFilePath = this.moduleSetup.get("privatekey.file.path", null);
        this.publickeyFilePath = this.moduleSetup.get("publickey.file.path", null);
        this.chargeTypeId = this.moduleSetup.getInt("softkey.charge.type", -1);
        this.maxSubscribeCount = this.moduleSetup.getInt("softkey.max.subscribe.count", 1);
        this.fioPid = this.moduleSetup.getInt("softkey.fio.pid", -1);
        this.emailPid = this.moduleSetup.getInt("softkey.email.pid", -1);
    }

    public int getAc() {
        return this.ac;
    }

    public void setAc(int ac) {
        this.ac = ac;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getWebMenuTitle() {
        return this.webMenuTitle;
    }

    public void setWebMenuTitle(String webMenuTitle) {
        this.webMenuTitle = webMenuTitle;
    }

    public int getChargeTypeId() {
        return this.chargeTypeId;
    }

    public void setChargeTypeId(int chargeTypeId) {
        this.chargeTypeId = chargeTypeId;
    }

    public int getMaxSubscribeCount() {
        return this.maxSubscribeCount;
    }

    public void setMaxSubscribeCount(int maxSubscribeCount) {
        this.maxSubscribeCount = maxSubscribeCount;
    }

    public int getFioPid() {
        return this.fioPid;
    }

    public void setFioPid(int fioPid) {
        this.fioPid = fioPid;
    }

    public int getEmailPid() {
        return this.emailPid;
    }

    public void setEmailPid(int emailPid) {
        this.emailPid = emailPid;
    }

    public PublicKey getSoftkeyPublicKey() throws BGMessageException, BGException {
        PublicKey key = null;
        if (Utils.isBlankString((String)this.publicSKkeyFilePath)) {
            throw new BGMessageException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0443\u0442\u044c \u0434\u043e \u043a\u043b\u044e\u0447\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 Softkey! (\u043e\u043f\u0446\u0438\u044f \"softkey.publickey.file.path\")");
        }
        byte[] publickeyBytes = this.readBytes(this.publicSKkeyFilePath);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publickeyBytes);
        try {
            key = KeyFactory.getInstance("RSA").generatePublic(keySpec);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return key;
    }

    public PrivateKey getISPPrivateKey() throws BGMessageException, BGException {
        PrivateKey key = null;
        if (Utils.isBlankString((String)this.privatekeyFilePath)) {
            throw new BGMessageException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0443\u0442\u044c \u0434\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430! (\u043e\u043f\u0446\u0438\u044f \"privatekey.file.path\")");
        }
        byte[] privatekeyBytes = this.readBytes(this.privatekeyFilePath);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privatekeyBytes);
        try {
            key = KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return key;
    }

    public PublicKey getISPPublicKey() throws BGException {
        PublicKey key = null;
        byte[] pubBytes = this.readBytes(this.publickeyFilePath);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubBytes);
        try {
            key = KeyFactory.getInstance("RSA").generatePublic(keySpec);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return key;
    }

    private byte[] readBytes(String filePath) throws BGException {
        String pubKeyBegin = "-----BEGIN PUBLIC KEY-----";
        String pubKeyEnd = "-----END PUBLIC KEY-----";
        String privKeyBegin = "-----BEGIN PRIVATE KEY-----";
        String privKeyEnd = "-----END PRIVATE KEY-----";
        byte[] result = null;
        File file = new File(filePath);
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            char[] tmpFileContent = new char[fis.available()];
            reader.read(tmpFileContent);
            StringBuilder str = new StringBuilder(new String(tmpFileContent));
            if (str.indexOf(pubKeyBegin) >= 0) {
                str.delete(0, pubKeyBegin.length() + 1);
                str.delete(str.indexOf(pubKeyEnd) - 1, str.length());
            }
            if (str.indexOf(privKeyBegin) >= 0) {
                str.delete(0, privKeyBegin.length() + 1);
                str.delete(str.indexOf(privKeyEnd) - 1, str.length());
            }
            result = new byte[str.length()];
            result = Base64.decode((byte[])str.toString().getBytes());
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

