<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<fmt:setLocale value="RU"/>

<c:if test="${not empty error}"><div class="alert alert-danger" role="alert">${error}</div></c:if>		

<ul class="nav nav-tabs mx-5">
  <li class="nav-item">
    <a class="nav-link active" aria-current="page" href="#">Текущий</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" href="#" onclick="showBlock( 'statusRoot', 'log', statusQuery );">История</a>
  </li>
</ul>

<div class="tile tileTabs">

	<div class="alert alert-info fs-6">
		<div class="">Здесь можно приостановить или активировать договор.</div>
		<div class="">Приостановить договор можно не ранее завтрашнего числа. Активировать можно начиная с сегодняшнего.</div>
	</div>

	<div class="d-flex flex-column">
	<div class="fs-2 text-center m-4">${statusstr}</div>
	<c:choose>
		<%-- если canchange=1 (CANCHANGE_DISABLED) --%>
		<c:when test="${canchange == 1}"><div class="message">Смена статуса запрещена системой</div></c:when>
		<%-- если canchange=2 (CANCHANGE_DISABLED_BADSTATUS) --%>
		<c:when test="${canchange == 2}"><div class="message">Смена статуса невозможна из текущего статуса</div></c:when>		
		<%-- если canchange=3 (CANCHANGE_DO) --%>
		<c:when test="${canchange == 3}">
			<form>
				<div class="text-center m-4">
					<c:choose>
						<%-- CONTRACT_STATUS_ACTIVE --%>
						<c:when test="${statusint == 0}">Приостановить <input type="hidden" name="status" value="4" /></c:when>
						<%-- CONTRACT_STATUS_SUSPENDED --%>
						<c:when test="${statusint == 4}">Активировать <input type="hidden" name="status" value="0" /></c:when>						
					</c:choose>
					договор с
				</div>
				<div class="text-center m-4"><select class="select2" name="dateFrom"><c:forEach var="item" items="${fromDates}"><fmt:formatDate var="d" value="${item}" type="DATE" dateStyle="SHORT"/><option value="${d}">${d}</option></c:forEach></select></div>
				<%-- раскомментировать если требуется возможность указывать дату ДО при смене статуса
				<c:if test="${statusint == 0 and not empty toDates}">
				<div style="margin-top: 15px;">по</div>
				<div style="margin-top: 15px;"><select class="gradbtn" name="dateTo" ><c:forEach var="item" items="${toDates}"><fmt:formatDate var="d" value="${item}" type="DATE" dateStyle="SHORT"/><option value="${d}">${d}</option></c:forEach></select></div>
				</c:if>
				--%>
				<div class="formButtons text-center"><button class="btn btn-primary" onclick="showBlock( 'statusRoot', 'status', { ...statusQuery, command: 'Change', status: this.form.status.value, dateFrom: this.form.dateFrom.value } ); return false;">Выполнить</button></div>
			</form>
		</c:when>
		<%-- если canchange=4 (CANCHANGE_CANCEL_ALLOW) --%>
		<c:when test="${canchange == 4}">
			<div style="margin: 10px;">На будущее число запланирована смена статуса. Вы можете отменить её.</div>
			<div class="formButtons"><button class="btn btn-primary" onclick="showBlock( 'statusRoot', 'status', { ...statusQuery, command: 'Cancel' } ); return false;">Отменить</button></div>
		</c:when>
		<%-- если canchange=5 (CANCHANGE_CANCEL_DENY) --%> 
		<c:when test="${canchange == 5}"><div class="message">На будущее число было запланирована смена(-ы) статуса, которую отменить нельзя.</div></c:when>
		<%-- если canchange иной --%>
		<c:otherwise><div class="alert alert-danger" role="alert">Ошибка. Статус нельзя изменить. Обратитесь к оператору [canchange=${canchange}].</div></c:otherwise>
	</c:choose>
	</div>

	<c:if test="${not empty statusFutureTasks}">
	<bg:blockTitle title="Задания на изменение статуса"/>
	<c:forEach var="statusFutureTask" items="${statusFutureTasks}">
	<div class="d-flex flex-row justify-content-between">
		<fmt:formatDate var="date" type="DATE" dateStyle="SHORT" value="${statusFutureTask[1]}"/>
		<div class="my-2">С <span class="fw-bold">${date}</span> изменить статус на <span class="fw-bold">${statusFutureTask[2]}</span></div>
		<c:if test="${statusFutureTask[0].createUserId == -1}"><div class=""><button class="btn btn-secondary" onclick="showBlock( 'statusRoot', 'status', { ...statusQuery, command: 'Cancel', date: '${date}' } ); return false;">Отменить</button></div></c:if>
	</div>
	</c:forEach>
	</c:if>
</div>