/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.task;

import java.time.LocalDate;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.plugins.cashcheck.server.task.AdvancePayments;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class AdvancePaymentsManual
extends RunTask {
    private LocalDate month;
    private List<Integer> contractsIds;

    public AdvancePaymentsManual(LocalDate month, List<Integer> contractsIds) {
        this.month = month;
        this.contractsIds = contractsIds;
    }

    public String getDescription() {
        AdvancePayments za = new AdvancePayments();
        za.initTask(Setup.getSetup(), 0, "");
        za.setExecutingTime(new GregorianCalendar());
        za.setManual(this.month, this.contractsIds);
        return za.getDescription();
    }

    public void executeTask() {
        AdvancePayments za = new AdvancePayments();
        za.initTask(this.setup, 0, "");
        za.setExecutingTime(new GregorianCalendar());
        za.setManual(this.month, this.contractsIds);
        za.startTask();
    }

    public String getUniqueKeyQueue() {
        String mmonth = TimeUtils.format((LocalDate)this.month, (String)"MM.yyyy");
        String contracts = Utils.notEmptyCollection(this.contractsIds) ? Utils.toString(this.contractsIds) : "all";
        return "cashcheck-advancepayments-" + mmonth + "-" + contracts;
    }

    public String getUniqueKeyParallel() {
        return "cashcheck-advancepayments";
    }
}

