/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.cdr;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.upload.SormFTPTransferFiles;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadFiles;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRItem;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRUpload;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadLogsTable;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class CDRUploadCommon
implements CDRUpload {
    private static final Logger log = LogManager.getLogger();
    protected final int sormModuleId;
    protected final int voiceModuleId;
    protected final SormProject sormProject;
    protected final Preferences config;
    protected String localUserPath;
    protected String regionId;
    protected final Connection connection;

    public CDRUploadCommon(int sormModuleId, SormProject sormProject) throws BGException {
        this.sormModuleId = sormModuleId;
        this.sormProject = sormProject;
        this.config = sormProject.getLoadedConfig();
        ServerContext serverContext = (ServerContext)ServerContext.get();
        this.connection = serverContext.getConnection();
        this.localUserPath = Utils.maskBlank((String)this.config.get("sorm.local.catalog"), (String)"");
        if (this.localUserPath.endsWith("/")) {
            this.localUserPath = this.localUserPath.substring(0, this.localUserPath.length() - 1);
        }
        this.regionId = this.config.get("sorm.upload.regionid", "1");
        List<Integer> voiceModuleIds = SormUtils.getTelephoneModulesIds(this.config).get(UploadModulesTitle.VOICE.getTitleModule());
        if (Utils.isEmptyCollection(voiceModuleIds)) {
            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c ID \u043c\u043e\u0434\u0443\u043b\u044f Voice \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0421\u041e\u0420\u041c \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043b\u043e\u0433\u043e\u0432!");
        }
        this.voiceModuleId = voiceModuleIds.get(0);
        this.prepareCDRUploadedLogTables();
    }

    private void prepareCDRUploadedLogTables() throws BGException {
        try {
            String thisMonthTable = ServerUtils.getModuleMonthTableName((String)"sorm_cdr_upload_log", (Date)new Date(), (int)this.sormModuleId);
            ServerUtils.checkTable((Connection)this.connection, (String)thisMonthTable, (String)SormUploadLogsTable.getUploadCdrLogTableCreateQuery(thisMonthTable));
            String previousMonthTable = ServerUtils.getModuleMonthTableName((String)"sorm_cdr_upload_log", (Date)TimeUtils.convertLocalDateTimeToDate((LocalDateTime)LocalDateTime.now().minusMonths(1L)), (int)this.sormModuleId);
            if (LocalDateTime.now().getDayOfMonth() == 1) {
                List<String> tables = this.getAllLogTables();
                tables.removeIf(table -> table.equals(thisMonthTable) || table.equals(previousMonthTable));
                this.removeOutdatedLogTables(tables);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private List<String> getAllLogTables() throws BGException {
        ArrayList<String> tables = new ArrayList<String>();
        try (Statement st = this.connection.createStatement();
             ResultSet rs = st.executeQuery("SHOW TABLES LIKE '%sorm_cdr_upload_log%'");){
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return tables;
    }

    private void removeOutdatedLogTables(List<String> tables) throws BGException {
        for (String table : tables) {
            try {
                Statement st = this.connection.createStatement();
                try {
                    st.executeUpdate("DROP TABLE " + table);
                }
                finally {
                    if (st == null) continue;
                    st.close();
                }
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    @Override
    public void uploadCDR() throws BGException {
        List<CDRItem> newItems = this.getNewCDRItemsForProcessing();
        if (Utils.isEmptyCollection(newItems)) {
            log.info("\u041d\u0435\u0442 \u043d\u043e\u0432\u044b\u0445 CDR \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438");
            return;
        }
        Path cdrFile = this.getFile();
        try (SormCSVWriter csvFileWriter = this.getCSVWriter(cdrFile);){
            Date startUploadTime = new Date();
            String[] header = this.getHeader();
            if (header != null) {
                csvFileWriter.writeNext(header);
            }
            log.info("\u041d\u043e\u0432\u044b\u0445 CDR \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438=" + newItems.size());
            for (CDRItem cdrItem : newItems) {
                csvFileWriter.writeNext(this.getCDRItem(cdrItem));
                csvFileWriter.flush();
            }
            log.debug("\u041d\u043e\u0432\u044b\u0435 cdr \u0437\u0430\u043f\u0438\u0441\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u044b");
            if ("1".equals(this.config.get("sorm.ftp.upload.enable"))) {
                log.info("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e CDR \u0444\u0430\u0439\u043b\u0430 \u043d\u0430 FTP: " + String.valueOf(cdrFile));
                new SormFTPTransferFiles(new UploadFiles(false).addFile(cdrFile), this.config, null);
            } else {
                log.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0430 FTP \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430!");
            }
            log.info("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0432 setup \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 cdr \u0434\u043b\u044f \u0441\u043e\u0440\u043c\u0430 = " + startUploadTime.getTime());
            ServerUtils.setSetupValue((Connection)this.connection, (String)"sorm_cdr_last_processing", (String)String.valueOf(startUploadTime.getTime()));
            log.info("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0432 \u043b\u043e\u0433 \u0442\u0430\u0431\u043b\u0438\u0446\u0443");
            this.saveUploadedNewItems(newItems);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private SormCSVWriter getCSVWriter(Path cdrFile) throws IOException {
        boolean withQuote;
        boolean bl = withQuote = !this.getSormManufacturer().equals((Object)SormManufacturer.MFISOFT) && !this.getSormManufacturer().equals((Object)SormManufacturer.SPECIALTECHNOLOGY) && !this.getSormManufacturer().equals((Object)SormManufacturer.NORSITRANS);
        if (this.getSormManufacturer().equals((Object)SormManufacturer.NORSITRANS)) {
            return SormUtils.getCSVFile(cdrFile, Charset.forName("windows-1251"), '\u0000', '\t');
        }
        return withQuote ? SormUtils.getCSVFile(cdrFile) : SormUtils.getCSVFile(cdrFile, '\u0000');
    }

    private void saveUploadedNewItems(List<CDRItem> cdrItems) throws BGException {
        if (Utils.isEmptyCollection(cdrItems)) {
            return;
        }
        String query = "INSERT INTO " + ServerUtils.getModuleMonthTableName((String)"sorm_cdr_upload_log", (Date)cdrItems.get((int)0).startTime, (int)this.sormModuleId) + " (startDate, callingNumber, calledNumber, deviceId, contractId) VALUES (?, ?, ?, ?, ?)";
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            for (CDRItem cdrItem : cdrItems) {
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)cdrItem.startTime));
                ps.setString(2, cdrItem.callingNumber);
                ps.setString(3, cdrItem.calledNumber);
                ps.setInt(4, cdrItem.deviceId);
                ps.setInt(5, cdrItem.contractId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private List<CDRItem> getNewCDRItemsForProcessing() throws BGException {
        try {
            Date lastProcessingTime = new Date(this.getLastProcessingTime());
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(2, -1);
            String monthAgoTable = ServerUtils.getModuleMonthTableName((String)"voice_session_log", (Date)cal.getTime(), (int)this.voiceModuleId);
            ArrayList<CDRItem> logsAfterLastUploadDate = new ArrayList<CDRItem>();
            logsAfterLastUploadDate.addAll(this.getLogsAfterDate(lastProcessingTime, monthAgoTable));
            logsAfterLastUploadDate.addAll(this.getLogsAfterDate(lastProcessingTime, ServerUtils.getModuleMonthTableName((String)"voice_session_log", (Date)new Date(), (int)this.voiceModuleId)));
            this.removePreviouslyUploaded(logsAfterLastUploadDate);
            return logsAfterLastUploadDate;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private List<CDRItem> getLogsAfterDate(Date date, String tableName) throws SQLException {
        ArrayList<CDRItem> result = new ArrayList<CDRItem>();
        if (!ServerUtils.tableExists((Connection)this.connection, (String)tableName)) {
            log.warn("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 " + tableName + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            return result;
        }
        if (!ServerUtils.columnExist((Connection)this.connection, (String)tableName, (String)"uploadTime")) {
            log.warn("\u041a\u043e\u043b\u043e\u043d\u043a\u0430 uploadTime \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435=" + tableName);
            return result;
        }
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM " + tableName + " WHERE uploadTime>?");){
            ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)date));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    CDRItem cdrItem = new CDRItem();
                    cdrItem.contractId = rs.getInt("contractId");
                    cdrItem.callingNumber = rs.getString("e164CallingStationId");
                    cdrItem.calledNumber = rs.getString("e164CalledStationId");
                    cdrItem.startTime = TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("sessionStart"));
                    cdrItem.duration = rs.getInt("sessionTime");
                    cdrItem.fromPort = rs.getString("fromPort");
                    cdrItem.toPort = rs.getString("toPort");
                    cdrItem.callType = rs.getInt("callType");
                    cdrItem.deviceId = rs.getInt("deviceId");
                    result.add(cdrItem);
                }
            }
        }
        return result;
    }

    private void removePreviouslyUploaded(List<CDRItem> logsAfterLastUploadDate) {
        logsAfterLastUploadDate.removeIf(cdrItem -> {
            boolean needRemove = false;
            String table = ServerUtils.getModuleMonthTableName((String)"sorm_cdr_upload_log", (Date)cdrItem.startTime, (int)this.sormModuleId);
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT count(*) FROM " + table + " WHERE startDate=? AND callingNumber=? AND calledNumber=? AND deviceId=? AND contractId=?");){
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)cdrItem.startTime));
                ps.setString(2, cdrItem.callingNumber);
                ps.setString(3, cdrItem.calledNumber);
                ps.setInt(4, cdrItem.deviceId);
                ps.setInt(5, cdrItem.contractId);
                ResultSet rs = ps.executeQuery();
                needRemove = rs.next() && rs.getInt(1) > 0;
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
            return needRemove;
        });
    }

    protected long getLastProcessingTime() throws Exception {
        String lastSavedProcessingTime = ServerUtils.getSetupValue((Connection)this.connection, (String)"sorm_cdr_last_processing");
        if (Utils.isBlankString((String)lastSavedProcessingTime)) {
            log.debug("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b setup");
        } else {
            log.debug("\u0412\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b setup = " + TimeUtils.formatFullDate((Date)new Date(Utils.parseLong((String)lastSavedProcessingTime))));
        }
        return Utils.parseLong((String)lastSavedProcessingTime, (long)TimeUtils.convertLocalDateTimeToDate((LocalDateTime)LocalDateTime.now().minusDays(1L)).getTime());
    }

    protected String generateCallId(CDRItem cdrItem) {
        Calendar c = Calendar.getInstance();
        c.setTime(cdrItem.startTime);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        return cdrItem.callingNumber + (hour * minute + second);
    }

    protected String getServiceId() {
        return this.config.get("sorm.upload.cdr.serviceId", "\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e");
    }

    protected boolean isOurNumber(String number) {
        long numA = Utils.parseLong((String)number);
        return SormUtils.getUploadVoiceNumberingResources(this.config, (ServerContext)ServerContext.get()).stream().anyMatch(n -> numA >= n.getFromNumber() && numA <= n.getToNumber());
    }
}

