/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.hd.server.bean.NsServer;

public class NsServerManager
extends AbstarctDaoConstant {
    public NsServerManager(Connection con, int moduleId) {
        super(con, "hd_ns_server", moduleId);
    }

    public NsServer getServer(int id) {
        NsServer result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getServerFromRs(rs);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<NsServer> getServerList() {
        ArrayList<NsServer> result = new ArrayList<NsServer>();
        String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getServerFromRs(rs));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updateServer(NsServer server) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            if (server.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (title, host, addr, port, key, comment) VALUES (?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query);
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, host=?, addr=?, port=?, `key`=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
            }
            ps.setString(index++, server.getTitle());
            ps.setString(index++, server.getHost());
            ps.setString(index++, server.getAddr());
            ps.setInt(index++, server.getPort());
            ps.setString(index++, server.getKey());
            ps.setString(index++, server.getComment());
            if (server.getId() > 0) {
                ps.setInt(index++, server.getId());
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteServer(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    private NsServer getServerFromRs(ResultSet rs) throws SQLException {
        NsServer result = new NsServer();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setHost(rs.getString("host"));
        result.setAddr(rs.getString("addr"));
        result.setPort(rs.getInt("port"));
        result.setKey(rs.getString("key"));
        result.setComment(rs.getString("comment"));
        return result;
    }
}

