/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gazprombank.server.event.worker;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.gazprombank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.gazprombank.server.event.GazprombankCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class GazprombankCheckEventWorker
extends EventWorker {
    private long sleepTimeout = 300L;

    public GazprombankCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), GazprombankCheckEvent.class, moduleId, -1, null);
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        this.sleepTimeout = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getLong("gazprombank.check.event.worker.sleep.timeout", 300L);
        this.getLogger().info("Starting GazprombankCheckEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "gazprombank-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        GazprombankCheckEvent event = (GazprombankCheckEvent)((Object)task);
        try {
            TransactionManager transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
            if (event.getTransactionId() > 0) {
                Transaction transaction = (Transaction)transactionManager.get(event.getTransactionId());
                if (transaction != null) {
                    transactionManager.doCheckRequest(transaction);
                }
            } else {
                transactionManager.doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        try {
            Thread.sleep(this.sleepTimeout);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return null;
    }
}

