/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.card.server.bean.CardAction;

public class CardActionCardManager
extends AbstarctDaoConstant {
    private final String TABLE_CARD_DATA;

    public CardActionCardManager(Connection con, int moduleId) {
        super(con, "card_action_card", moduleId);
        this.TABLE_CARD_DATA = "card_data_" + moduleId;
    }

    public void updateCards(int cardActionId, List<Long> cards) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE action_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cardActionId);
            ps.executeUpdate();
        }
        query = "INSERT INTO " + this.tableName + " SET action_id=?, card_id=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, cardActionId);
            for (Long card : cards) {
                ps.setLong(2, card);
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public List<Long> getCards(int cardActionId) throws SQLException {
        ArrayList<Long> result = new ArrayList<Long>();
        String query = "SELECT card_id FROM " + this.tableName + " WHERE action_id=? ORDER BY card_id";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cardActionId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getLong(1));
                }
            }
        }
        return result;
    }

    public boolean checkCanUndo(CardAction action) throws SQLException {
        boolean result = false;
        String query = "SELECT COUNT(*) FROM " + this.tableName + " AS action_card INNER JOIN " + this.TABLE_CARD_DATA + " AS card ON action_card.card_id=card.id AND action_card.action_id=? AND card.status!=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, action.getId());
            if (action.getType() == 1) {
                ps.setInt(2, 1);
            } else {
                ps.setInt(2, 0);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1) == 0;
                }
            }
        }
        return result;
    }

    public Map<Float, Integer> getCostGroups(int cardAction) throws SQLException {
        TreeMap<Float, Integer> result = new TreeMap<Float, Integer>();
        String query = "SELECT card.summa, COUNT(*) FROM " + this.TABLE_CARD_DATA + " AS card INNER JOIN " + this.tableName + " AS action_card ON card.id=action_card.card_id WHERE action_card.action_id=? GROUP BY card.summa";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cardAction);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.put(Float.valueOf(rs.getFloat(1)), rs.getInt(2));
                }
            }
        }
        return result;
    }
}

