/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree.voice;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.kernel.tariff.client.tree.voice.RangeEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.voice.RoundListItem;

class RangeList
extends JPanel
implements ActionListener {
    private RoundListItem listItem;
    private DefaultListModel<RoundListItem> listModel = new DefaultListModel();
    private JList<RoundListItem> list = new JList<RoundListItem>(this.listModel);
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private RangeEditor editor = new RangeEditor();

    public RangeList() {
        this.toolBar.setDefaultButtons((ActionListener)this);
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(1);
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder(" \u041f\u0440\u0430\u0432\u0438\u043b\u0430 \u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0438\u044f "));
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.list), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.editor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (RangeList.this.listItem != null && RangeList.this.listItem.getData() != null) {
                    RangeList.this.listModel.addElement(RangeList.this.listItem);
                }
                RangeList.this.list.repaint();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RangeList.this.actionPerformed(new ActionEvent(this, 0, "editItem"));
                }
            }
        });
    }

    public void setData(String data) {
        this.listModel.clear();
        String[] lines = data.split(",");
        int size = lines.length;
        for (int i = 0; i < size; ++i) {
            RoundListItem listItem = new RoundListItem();
            listItem.setData(lines[i]);
            this.listModel.addElement(listItem);
        }
        this.list.repaint();
    }

    public String getData() {
        StringBuffer result = new StringBuffer(320);
        int size = this.listModel.getSize();
        for (int i = 0; i < size; ++i) {
            RoundListItem listItem = this.listModel.getElementAt(i);
            if (result.length() != 0) {
                result.append(",");
            }
            result.append(listItem.getData());
        }
        if (result.length() == 0) {
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("deleteItem".equals(command)) {
            int pos = this.list.getSelectedIndex();
            if (pos >= 0) {
                this.listModel.removeElementAt(pos);
            }
        } else if ("editItem".equals(command)) {
            this.listItem = null;
            RoundListItem listItem = this.list.getSelectedValue();
            if (listItem != null) {
                this.editor.setData(listItem);
                this.editor.setVisible(true);
            }
        } else if ("newItem".equals(command)) {
            this.listItem = new RoundListItem();
            this.editor.setData(this.listItem);
            this.editor.setVisible(true);
        }
    }
}

