/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.util.CopyOnWriteListMap;
import ru.bitel.common.util.Matcher;

public class TimeoutListMapOld<K extends Comparable<K>, V> {
    private static final Logger logger = LogManager.getLogger();
    private final CopyOnWriteListMap<K, V> map;
    private final Queue<Map.Entry<K, V>> queue;
    private final Matcher<Map.Entry<K, V>> matcher;
    private final Runnable worker;

    public TimeoutListMapOld(Matcher<Map.Entry<K, V>> matcher, ScheduledExecutorService scheduledExecutorService, long initialDelay, long period, TimeUnit unit) {
        if (matcher == null) {
            throw new IllegalArgumentException();
        }
        this.map = new CopyOnWriteListMap(64, 2);
        this.queue = new LinkedBlockingQueue<Map.Entry<K, V>>();
        this.matcher = matcher;
        this.worker = new MatcherWorker();
        scheduledExecutorService.scheduleAtFixedRate(this.worker, initialDelay, period, unit);
    }

    public TimeoutListMapOld(DelayQueue<? extends Map.Entry<K, V>> queue, ScheduledExecutorService scheduledExecutorService, long initialDelay, long period, TimeUnit unit) {
        this.map = new CopyOnWriteListMap(64, 2);
        this.queue = queue;
        this.matcher = null;
        this.worker = new Worker();
        scheduledExecutorService.scheduleWithFixedDelay(this.worker, initialDelay, period, unit);
    }

    public TimeoutListMapOld(BlockingQueue<? extends Map.Entry<K, V>> queue, String workerName) {
        this.map = new CopyOnWriteListMap(64, 2);
        this.queue = queue;
        this.matcher = null;
        this.worker = new ThreadWorker();
        new Thread(this.worker, workerName).start();
    }

    public void add(K key, V value) {
        this.map.add(key, value);
        this.queue.add(new AbstractMap.SimpleEntry<K, V>(key, value));
    }

    public void add(Map.Entry<K, V> keyValue) {
        this.map.add((Comparable)keyValue.getKey(), keyValue.getValue());
        this.queue.add(keyValue);
    }

    public boolean remove(K key, V value) {
        return this.map.remove(key, value);
    }

    public List<V> get(K key) {
        return this.map.get(key);
    }

    public List<V> remove(K key) {
        return this.map.remove(key);
    }

    private class MatcherWorker
    implements Runnable {
        private MatcherWorker() {
        }

        @Override
        public void run() {
            try {
                Map.Entry k;
                Queue queue = TimeoutListMapOld.this.queue;
                while ((k = queue.peek()) != null && TimeoutListMapOld.this.matcher.matched(k)) {
                    k = queue.poll();
                    TimeoutListMapOld.this.map.remove((Comparable)k.getKey(), k.getValue());
                }
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                Map.Entry k;
                Queue queue = TimeoutListMapOld.this.queue;
                while ((k = queue.poll()) != null) {
                    TimeoutListMapOld.this.map.remove((Comparable)k.getKey(), k.getValue());
                }
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    private class ThreadWorker
    implements Runnable {
        private ThreadWorker() {
        }

        @Override
        public void run() {
            BlockingQueue queue = (BlockingQueue)TimeoutListMapOld.this.queue;
            while (true) {
                try {
                    while (true) {
                        Map.Entry k = (Map.Entry)queue.take();
                        TimeoutListMapOld.this.map.remove((Comparable)k.getKey(), k.getValue());
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    BGLogger.error((Throwable)ex);
                    continue;
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                    continue;
                }
                break;
            }
        }
    }
}

