/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.util.Collections;
import java.util.Date;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.jasperreports.engine.JasperReport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.FOUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.util.FileDownload;

@WebServlet(name="billPDFExecutor", urlPatterns={"/pdfexecuter"})
public class PDFExecutor
extends CommonExecutor {
    public void init() {
        this.setup = Setup.getSetup();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int moduleId = -1;
        Connection con = null;
        boolean invoice = request.getParameter("Invoice") != null;
        try {
            Integer contractId = (Integer)request.getSession().getAttribute("clientid");
            if (contractId != null) {
                moduleId = Utils.parseInt((String)request.getParameter("mid"), (int)moduleId);
                int id = Utils.parseInt((String)request.getParameter("id"), (int)-1);
                if (moduleId > 0 && contractId > 0 && id > 0) {
                    con = this.setup.getDBConnectionFromPool();
                    byte[] data = invoice ? new InvoiceManager(con, moduleId).getXMLData(contractId, id) : new BillManager(con, moduleId).getXMLData(contractId, id);
                    request.setAttribute("contentType", (Object)"binary");
                    String patternName = BillUtil.getPatternName(invoice ? DocumentSendParameters.SendingDataType.INVOICE : DocumentSendParameters.SendingDataType.BILL, con, moduleId, id);
                    this.docl2PDF(con, data, patternName, request, response, invoice);
                }
            } else {
                response.sendRedirect(request.getContextPath() + "/webexecuter");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (moduleId > 0) {
                response.sendRedirect(request.getContextPath() + "/webexecuter/m" + moduleId + (invoice ? "/Invoice" : "/Bill"));
            }
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private void docl2PDF(Connection con, byte[] data, String patternName, HttpServletRequest request, HttpServletResponse response, boolean invoice) throws IOException {
        try {
            Date date;
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            Document doc = XMLUtils.parseDocument((InputSource)new InputSource(bis));
            Element bill = (Element)doc.getDocumentElement().getElementsByTagName("bill").item(0);
            StringBuilder fileName = new StringBuilder(50);
            if (invoice) {
                fileName.append("Invoice_");
            } else {
                fileName.append("Bill_");
            }
            String contract = bill.getAttribute("contract");
            if (Utils.notBlankString((String)contract)) {
                fileName.append(contract).append("_");
            }
            if ((date = TimeUtils.parseDate((String)bill.getAttribute("date"), (String)"dd.MM.yyyy")) != null) {
                fileName.append(TimeUtils.format((Date)date, (String)"yyyyMMdd"));
            }
            fileName.append(".pdf");
            bill.setAttribute("with_stamp", "1");
            response.setContentType("application/pdf");
            response.setHeader("Content-Disposition", FileDownload.getContentDisposition((HttpServletRequest)request, (String)fileName.toString(), (boolean)true));
            if (patternName.endsWith(".jrxml")) {
                JasperReport report = BGReportTemplate.getJasperReport((ParameterMap)this.setup, (URI)new File(XSLManager.getInstance().getXslRootPath() + patternName).toURI());
                BGReportFilter reportFilter = new BGReportFilter(Collections.emptyMap(), (Preferences)this.setup, 0);
                BGReportTemplate.fillReportToPdfStream((JasperReport)report, (BGReportFilter)reportFilter, (Connection)con, (Document)doc, (OutputStream)response.getOutputStream());
            } else {
                XSLManager.getInstance().transform((Source)new DOMSource(doc), patternName, (Result)FOUtils.renderSAXResult((OutputStream)response.getOutputStream(), (String)"application/pdf"));
            }
        }
        catch (Exception ex) {
            BGLogger.error((Throwable)ex);
        }
    }
}

