/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class FindContractUtils {
    public static int findContractByParameter(Connection con, int parameterId, String value) throws BGException {
        int result = 0;
        if (parameterId > 0 && !Utils.isEmptyString((String)value)) {
            try {
                int type;
                ContractParameterPref contractParameterPref = (ContractParameterPref)new ContractParameterPrefDao(con).get(parameterId);
                int n = type = contractParameterPref == null ? -1 : contractParameterPref.getType().getId();
                if (type == 1) {
                    String query = "SELECT DISTINCT param.cid FROM contract_parameter_type_1 AS param LEFT JOIN contract ON contract.id=param.cid WHERE param.pid=? AND param.val=? ORDER BY contract.scid ASC";
                    PreparedStatement ps = con.prepareStatement(query);
                    ps.setInt(1, parameterId);
                    ps.setString(2, value);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        result = rs.getInt(1);
                    }
                    rs.close();
                    ps.close();
                } else if (type == 9) {
                    String query = "SELECT cid FROM contract_parameter_type_phone_item WHERE pid=? AND phone=?";
                    PreparedStatement ps = con.prepareStatement(query);
                    ps.setInt(1, parameterId);
                    ps.setString(2, value);
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        if (result > 0) {
                            result = -1;
                            break;
                        }
                        result = rs.getInt(1);
                    }
                    rs.close();
                    ps.close();
                    if (result == 0) {
                        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430, \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u044f\u044e\u0449\u0438\u0445 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c [\u043d\u043e\u043c\u0435\u0440=" + value + "]");
                    }
                    if (result < 0) {
                        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430, \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u044f\u044e\u0449\u0438\u0445 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c [\u043d\u043e\u043c\u0435\u0440=" + value + "]");
                    }
                }
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        return result;
    }

    public static int findContractByEmail(Connection con, String email) {
        int result = 0;
        if (!Utils.isEmptyString((String)email)) {
            try {
                String query = "SELECT DISTINCT cid FROM contract_parameter_3 WHERE email=?";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setString(1, email);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static int findContractByLogin(Connection con, int mid, String login) {
        int result = 0;
        if (mid > 0 && !Utils.isEmptyString((String)login)) {
            try {
                ResultSet rs;
                PreparedStatement ps;
                String query;
                try {
                    int ilogin = Integer.parseInt(login);
                    query = "SELECT cid FROM user_login_" + mid + " WHERE login=? AND (date1 IS NULL OR date1<=NOW()) AND (date2 IS NULL OR date2>=NOW())";
                    ps = con.prepareStatement(query);
                    ps.setInt(1, ilogin);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        result = rs.getInt(1);
                    }
                    ps.close();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (ServerUtils.tableExists((Connection)con, (String)("user_alias_" + mid))) {
                    query = "SELECT cid FROM user_alias_" + mid + " , user_login_" + mid + "   WHERE login_id=id AND login_alias=? AND (date1 IS NULL OR date1<=NOW()) AND (date2 IS NULL OR date2>=NOW())";
                    ps = con.prepareStatement(query);
                    ps.setString(1, login);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        result = rs.getInt(1);
                    }
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static int findContractByVoice(Connection con, int mid, String phone) {
        int result = 0;
        if (mid > 0 && !Utils.isEmptyString((String)phone)) {
            try {
                String query = "SELECT DISTINCT cid FROM user_login_" + mid + " WHERE (number=?) AND (date1 IS NULL OR date1<=NOW()) AND (date2 IS NULL OR date2>=NOW())";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setString(1, phone);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static int findContractByPhone(Connection con, int mid, String phone) {
        int result = 0;
        if (mid > 0 && !Utils.isEmptyString((String)phone)) {
            try {
                String query = "SELECT DISTINCT item.cid FROM phone_item_number_" + mid + " as number LEFT JOIN phone_client_item_" + mid + " as item ON number.item_id=item.id WHERE (number=?) AND (item.date1 IS NULL OR item.date1<=NOW()) AND (item.date2 IS NULL OR item.date2>=NOW())";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setString(1, phone);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result = rs.getInt(1);
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static int findContractByTitle(Connection con, String title) {
        int result = 0;
        if (!Utils.isEmptyString((String)title)) {
            try (PreparedStatement ps = con.prepareStatement("SELECT id FROM contract WHERE title=?");){
                ps.setString(1, title);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static int findContractByCerbercrypt(Connection con, int mid, String card) {
        int result = 0;
        int _card = Utils.parseInt((String)card, (int)-1);
        if (mid > 0 && _card > 0) {
            try {
                String query = "SELECT DISTINCT cid FROM user_card_" + mid + " WHERE number=?";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, _card);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static int findContractByMPSLogin(Connection con, int mid, String _login) {
        int result = 0;
        int login = Utils.parseInt((String)_login, (int)-1);
        if (login <= 0) {
            return 0;
        }
        if (mid > 0 && login > 0) {
            try {
                String query = "SELECT cid FROM mps_login_" + mid + " WHERE id=?";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, login);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static int findContractByInetLogin(Connection con, int moduleId, String inetLogin) throws BGException {
        int result = -1;
        if (moduleId > 0 && !Utils.isEmptyString((String)inetLogin)) {
            String query = "SELECT DISTINCT contractId FROM inet_serv_" + moduleId + " WHERE login=? AND (dateFrom IS NULL OR dateFrom<=NOW()) AND (dateTo IS NULL OR dateTo>=NOW())";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setString(1, inetLogin);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
                rs.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }
}

