/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common.table;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class SortTableHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    public SortTableHeaderRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon sortIcon = null;
        boolean isPaintingForPrint = false;
        if (table != null) {
            List<RowSorter.SortKey> sortKeys;
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this.setHorizontalTextPosition(10);
                Color fgColor = this.getForeground();
                Color bgColor = this.getBackground();
                this.setForeground(fgColor);
                this.setBackground(bgColor);
                this.setFont(this.getFont());
                isPaintingForPrint = header.isPaintingForPrint();
            }
            if (!isPaintingForPrint && table.getRowSorter() != null && (sortKeys = table.getRowSorter().getSortKeys()).size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
                switch (sortKeys.get(0).getSortOrder()) {
                    case ASCENDING: {
                        sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                        break;
                    }
                    case DESCENDING: {
                        sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                        break;
                    }
                    case UNSORTED: {
                        sortIcon = UIManager.getIcon("Table.naturalSortIcon");
                    }
                }
            }
        }
        this.setText(value == null ? "" : value.toString());
        this.setIcon(sortIcon);
        Border border = null;
        if (hasFocus) {
            border = UIManager.getBorder("TableHeader.focusCellBorder");
        }
        if (border == null) {
            border = UIManager.getBorder("TableHeader.cellBorder");
        }
        this.setBorder(border);
        return this;
    }
}

