/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.label.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService")
public class ContractLabelServiceImpl
extends AbstractService
implements ContractLabelService {
    ContractLabelManager contractLabelManager;

    @PostConstruct
    public void init() {
        this.contractLabelManager = new ContractLabelManager(this.getConnection());
    }

    @Override
    public List<ContractLabelItem> getContractLabelTreeItemList(int contractId, boolean calcCount) throws BGException {
        return (List)this.tryReturn(() -> {
            List<ContractLabelItem> contractLabelItems = this.contractLabelManager.getContractLabelItemList(calcCount);
            if (contractId > 0) {
                List<Integer> contractLabelSet = this.contractLabelManager.getContractLabelIds(contractId);
                for (ContractLabelItem contractLabelItem : contractLabelItems) {
                    contractLabelItem.setSelected(contractLabelSet.contains(contractLabelItem.getId()));
                }
            }
            Collections.sort(contractLabelItems);
            return contractLabelItems;
        });
    }

    @Override
    public List<ContractLabelItem> getContractLabelTreeItemListForUser(int userId) throws BGException {
        List<ContractLabelItem> contractLabelItems = this.contractLabelManager.getContractLabelItemList(false);
        Role role = PermissionOfRoles.getRoleByUserId(userId).orElse(null);
        if (role == null) {
            return contractLabelItems;
        }
        HashSet labelsOfContract = new HashSet();
        role.getPermissionKits().forEach(kit -> {
            if (kit.getContractLabels() != null) {
                labelsOfContract.addAll(kit.getContractLabels());
            }
        });
        if (Utils.isEmptyCollection(labelsOfContract)) {
            return contractLabelItems;
        }
        contractLabelItems.removeIf(l -> !labelsOfContract.contains(l.getId()) && l.getParentId() >= 0 && (l.getContractLabelType().equals((Object)ContractLabelType.LABEL_ITEM) || l.getContractLabelType().equals((Object)ContractLabelType.GROUP_ITEM)));
        contractLabelItems.removeIf(labelItem -> labelItem.getId() != 100 && labelItem.getContractLabelType().equals((Object)ContractLabelType.LABEL) && this.checkEmptyCategory((ContractLabelItem)labelItem, contractLabelItems));
        return contractLabelItems;
    }

    private boolean checkEmptyCategory(ContractLabelItem category, List<ContractLabelItem> contractLabels) {
        return contractLabels.stream().filter(l -> l.getParentId() == category.getId()).findAny().isEmpty();
    }

    @Override
    public List<Integer> getContractLabelIds(int contractId) throws BGException {
        return (List)this.tryReturn(() -> this.contractLabelManager.getContractLabelIds(contractId));
    }

    @Override
    public void setContractLabelIds(int contractId, List<Integer> contractLabelsIds) throws BGException {
        this.tryCall(() -> {
            this.contractLabelManager.setContractLabelIds(contractId, contractLabelsIds);
            EventProcessor.getInstance().publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
        });
    }

    @Override
    public void setContractLabelTreeItemList(int contractId, List<ContractLabelItem> items) throws BGException {
        if (items != null) {
            this.tryCall(() -> {
                this.contractLabelManager.setContractLabelIds(contractId, items.stream().mapToInt(Id::getId).boxed().toList());
                EventProcessor.getInstance().publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
            });
        }
    }

    @Override
    public int updateContractLabelTreeItem(ContractLabelItem contractLabelItem) throws BGException {
        Objects.requireNonNull(contractLabelItem);
        return (Integer)this.tryReturn(() -> {
            this.contractLabelManager.updateContractLabelTreeItem(contractLabelItem);
            return contractLabelItem.getId();
        });
    }

    @Override
    public void updateContractLabelTreeItems(List<ContractLabelItem> items) throws BGException {
        this.tryCall(() -> {
            if (Utils.notEmptyCollection((Collection)items)) {
                for (ContractLabelItem item : items) {
                    this.contractLabelManager.updateContractLabelTreeItem(item);
                }
            }
        });
    }

    @Override
    public void removeContractLabelTreeItem(int contractLabelItemId) throws BGException {
        this.tryCall(() -> this.contractLabelManager.removeContractLabelItem(contractLabelItemId));
    }

    @Override
    public ContractLabelItem getContractLabelTree() throws BGException {
        return (ContractLabelItem)this.tryReturn(() -> this.contractLabelManager.getTree());
    }

    @Override
    public void syncLabelAndGroupDirectory() throws BGException {
        this.tryCall(() -> this.contractLabelManager.syncLabelAndGroupDirectory());
    }

    @Override
    public void syncLabelAndGroupContract(int contractId) throws BGException {
        this.contractLabelManager.syncLabelAndGroupContract(contractId);
    }

    @Override
    public int getContractCountByLabel(int labelId) throws BGException {
        return (Integer)this.tryReturn(() -> this.contractLabelManager.getContractCountByLabel(labelId));
    }
}

