/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.util.Date;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.AbstractGeographicCode;
import ru.bitel.common.model.IdTitle;

@XmlRootElement
@XmlSeeAlso(value={AbstractGeographicCode.class})
public class RangeMapItem
extends IdTitle {
    private String rangeFrom;
    private String rangeTo;
    private int prefixLength;
    private String comment;
    private Date dateFrom;
    private Date dateTo;

    public String getRangeFrom() {
        return this.rangeFrom;
    }

    public void setRangeFrom(String rangeFrom) {
        this.rangeFrom = rangeFrom;
        this.build();
    }

    public String getRangeTo() {
        return this.rangeTo;
    }

    public void setRangeTo(String rangeTo) {
        this.rangeTo = rangeTo;
        this.build();
    }

    private void build() {
        if (this.rangeFrom != null && this.rangeTo != null) {
            int i;
            int size = Math.min(this.rangeFrom.length(), this.rangeTo.length());
            for (i = 0; i < size && this.rangeFrom.codePointAt(i) == this.rangeTo.codePointAt(i); ++i) {
            }
            this.prefixLength = i;
        }
    }

    @XmlAttribute(name="c")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean matches(String code) {
        if (code.regionMatches(0, this.rangeFrom, 0, this.prefixLength)) {
            int length = this.rangeFrom.length();
            if (code.length() < length) {
                return false;
            }
            return code.compareTo(this.rangeFrom) >= 0 && code.compareTo(this.rangeTo) <= 0;
        }
        return false;
    }

    public String toString() {
        return this.rangeFrom + " - " + this.rangeTo;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }
}

