/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Package;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class PackageManager
extends BGLogger {
    protected Connection con;
    protected BGPluginServer plugin = null;

    public PackageManager(Connection con, BGPluginServer plugin) {
        this.con = con;
        this.plugin = plugin;
    }

    protected String getDBTableName(String name) {
        return name + "_" + this.plugin.getPluginUID();
    }

    public void findPackageContractList(SearchResult<PackageContract> searchResult, int contractId) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            try {
                StringBuilder query = new StringBuilder();
                query.append("SELECT SQL_CALC_FOUND_ROWS * FROM ");
                query.append(this.getDBTableName("helpdesk_package_contract") + " AS hdp_con");
                query.append(" LEFT JOIN " + this.getDBTableName("helpdesk_package") + " AS hdp ON hdp_con.package_id=hdp.id");
                query.append(" WHERE 1=1");
                if (contractId > 0) {
                    query.append(" AND cid=");
                    query.append(contractId);
                }
                query.append(" ORDER BY date_from");
                query.append(Page.toSqlLimit((Page)page));
                try (Statement st = this.con.createStatement();
                     ResultSet rs = st.executeQuery(query.toString());){
                    while (rs.next()) {
                        PackageContract pckg = new PackageContract();
                        this.setPackageContractData(rs, pckg);
                        list.add(pckg);
                    }
                }
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public void findPackageList(SearchResult<Package> searchResult, Boolean status) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            try {
                StringBuilder query = new StringBuilder();
                query.append("SELECT SQL_CALC_FOUND_ROWS * FROM ");
                query.append(this.getDBTableName("helpdesk_package"));
                if (status != null) {
                    query.append(" WHERE status=");
                    query.append(status.toString());
                }
                query.append(" ORDER BY title");
                query.append(Page.toSqlLimit((Page)page));
                try (Statement st = this.con.createStatement();
                     ResultSet rs = st.executeQuery(query.toString());){
                    while (rs.next()) {
                        Package pckg = new Package();
                        this.setPackageData(rs, pckg);
                        list.add(pckg);
                    }
                }
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public Package getPackage(int id) {
        Package pkg = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append(this.getDBTableName("helpdesk_package"));
            query.append(" WHERE id=");
            query.append(id);
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                pkg = new Package();
                this.setPackageData(rs, pkg);
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return pkg;
    }

    public int updatePackageContractCount(int id, int countUse, int step) {
        int result = 0;
        try {
            int index = 1;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(this.getDBTableName("helpdesk_package_contract"));
            query.append(" SET count_use=count_use+? WHERE id=? AND count_use=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, step);
            ps.setInt(index++, id);
            ps.setInt(index++, countUse);
            result = ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public void updatePackage(Package pkg) {
        if (pkg != null) {
            try {
                if (pkg.getId() < 0) {
                    int index = 1;
                    PreparedStatement ps = null;
                    StringBuilder query = new StringBuilder();
                    query.append("INSERT INTO ");
                    query.append(this.getDBTableName("helpdesk_package"));
                    query.append(" SET title=?, summa=?, count=?, period=?, status=?, charge_id=?");
                    ps = this.con.prepareStatement(query.toString(), 1);
                    ps.setString(index++, pkg.getTitle());
                    ps.setBigDecimal(index++, pkg.getSumma());
                    ps.setInt(index++, pkg.getCount());
                    ps.setInt(index++, pkg.getPeriod());
                    ps.setBoolean(index++, pkg.isStatus());
                    ps.setInt(index++, pkg.getChargeId());
                    ps.executeUpdate();
                    pkg.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                    ps.close();
                } else {
                    int index = 1;
                    PreparedStatement ps = null;
                    StringBuilder query = new StringBuilder();
                    query.append("UPDATE ");
                    query.append(this.getDBTableName("helpdesk_package"));
                    query.append(" SET title=?, summa=?, count=?, period=?, status=?, charge_id=? WHERE id=?");
                    ps = this.con.prepareStatement(query.toString());
                    ps.setString(index++, pkg.getTitle());
                    ps.setBigDecimal(index++, pkg.getSumma());
                    ps.setInt(index++, pkg.getCount());
                    ps.setInt(index++, pkg.getPeriod());
                    ps.setBoolean(index++, pkg.isStatus());
                    ps.setInt(index++, pkg.getChargeId());
                    ps.setInt(index++, pkg.getId());
                    ps.executeUpdate();
                    ps.close();
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public void updatePackageContract(PackageContract packageContract) {
        if (packageContract != null) {
            try {
                if (packageContract.getId() < 0) {
                    int index = 1;
                    PreparedStatement ps = null;
                    StringBuilder query = new StringBuilder();
                    query.append("INSERT INTO ");
                    query.append(this.getDBTableName("helpdesk_package_contract"));
                    query.append(" SET package_id=?, cid=?, date_from=?, date_to=?,");
                    query.append(" summa=?, count=?, count_use=?, user_id=? ");
                    ps = this.con.prepareStatement(query.toString(), 1);
                    ps.setInt(index++, packageContract.getPackageId());
                    ps.setInt(index++, packageContract.getContractId());
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)packageContract.getDateFrom()));
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)packageContract.getDateTo()));
                    ps.setBigDecimal(index++, packageContract.getSumma());
                    ps.setInt(index++, packageContract.getCount());
                    ps.setInt(index++, packageContract.getCountUse());
                    ps.setInt(index++, packageContract.getUserId());
                    ps.executeUpdate();
                    packageContract.setContractId(ServerUtils.lastInsertId((PreparedStatement)ps));
                    ps.close();
                } else {
                    int index = 1;
                    PreparedStatement ps = null;
                    StringBuilder query = new StringBuilder();
                    query.append("UPDATE ");
                    query.append(this.getDBTableName("helpdesk_package_contract"));
                    query.append(" SET count_use=? WHERE id=?");
                    ps = this.con.prepareStatement(query.toString());
                    ps.setInt(index++, packageContract.getCountUse());
                    ps.setInt(index++, packageContract.getId());
                    ps.executeUpdate();
                    ps.close();
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public PackageContract getPackageContract(int id) {
        PackageContract pckg = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT hdp_con.*, hdp.* FROM ");
            query.append(this.getDBTableName("helpdesk_package_contract") + " AS hdp_con");
            query.append(" LEFT JOIN " + this.getDBTableName("helpdesk_package") + " AS hdp ON hdp_con.package_id=hdp.id");
            query.append(" WHERE hdp_con.id=");
            query.append(id);
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                pckg = new PackageContract();
                this.setPackageContractData(rs, pckg);
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return pckg;
    }

    public boolean hasActivePackage(int contractId) {
        return this.getActiveNotUseOrder(contractId) > 0;
    }

    public PackageContract getActivePackageContract(int contractId) {
        PackageContract pckg = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT hdp_con.*, hdp.* FROM ");
            query.append(this.getDBTableName("helpdesk_package_contract") + " AS hdp_con");
            query.append(" LEFT JOIN " + this.getDBTableName("helpdesk_package") + " AS hdp ON hdp_con.package_id=hdp.id");
            query.append(" WHERE hdp_con.date_from<now() AND hdp_con.date_to>now() AND hdp_con.count_use<hdp_con.count AND hdp_con.cid=");
            query.append(contractId);
            query.append(" ORDER BY hdp_con.date_to LIMIT 1");
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                pckg = new PackageContract();
                this.setPackageContractData(rs, pckg);
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return pckg;
    }

    public int getActiveNotUseOrder(int contractId) {
        int count = 0;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT count(count-count_use) FROM ");
            query.append(this.getDBTableName("helpdesk_package_contract"));
            query.append(" WHERE date_from<now() AND date_to>now() AND count_use<count AND cid=");
            query.append(contractId);
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return count;
    }

    private void setPackageData(ResultSet rs, Package pckg) throws SQLException {
        pckg.setId(rs.getInt("id"));
        pckg.setTitle(rs.getString("title"));
        pckg.setSumma(rs.getBigDecimal("summa"));
        pckg.setCount(rs.getInt("count"));
        pckg.setPeriod(rs.getInt("period"));
        pckg.setChargeId(rs.getInt("charge_id"));
        pckg.setStatus(rs.getBoolean("status"));
    }

    private void setPackageContractData(ResultSet rs, PackageContract pckg) throws SQLException {
        pckg.setId(rs.getInt("hdp_con.id"));
        pckg.setTitle(rs.getString("hdp.title"));
        pckg.setContractId(rs.getInt("hdp_con.cid"));
        pckg.setDateFrom((Date)rs.getDate("hdp_con.date_from"));
        pckg.setDateTo((Date)rs.getDate("hdp_con.date_to"));
        pckg.setSumma(rs.getBigDecimal("hdp_con.summa"));
        pckg.setCount(rs.getInt("hdp_con.count"));
        pckg.setCountUse(rs.getInt("hdp_con.count_use"));
        pckg.setUserId(rs.getInt("hdp_con.user_id"));
    }
}

