/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardActionsService;
import ru.bitel.common.Preferences;
import ru.bitel.common.client.LookAndFeelUtils;
import ru.bitel.common.client.PatternDocumentFilter;

public class CardSelectComboBox
extends JPanel
implements KeyListener,
ActionListener {
    private ClientContext context;
    private String[] cardsItems = null;
    private JComboBox<String> comboBox = new JComboBox<String>(){

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
            return size;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
            return size;
        }
    };
    private JTextComponent comboBoxEditor = null;
    private JCheckBox cbAutoComplete = new JCheckBox("\u0430\u0432\u0442\u043e\u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435");
    private JCheckBox cbFreeCardOnly = new JCheckBox("\u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435");
    private String previousEnteredText = "";

    public CardSelectComboBox(ClientContext context) {
        this.context = context;
        this.setLayout(new GridBagLayout());
        this.add(this.comboBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.cbAutoComplete, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.cbFreeCardOnly, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.comboBox.setEditable(true);
        this.comboBoxEditor = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
        this.comboBoxEditor.addKeyListener(this);
        if (this.comboBoxEditor.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)this.comboBoxEditor.getDocument()).setDocumentFilter((DocumentFilter)new PatternDocumentFilter(Pattern.compile("\\d*")));
        }
        this.cbAutoComplete.addActionListener(this);
        this.cbFreeCardOnly.addActionListener(this);
        this.loadCheckBoxState();
        this.comboBox.setRenderer(new CardSelectComboBoxRenderer());
    }

    private void saveCheckBoxState() {
        Preferences config = ClientSetup.getInstance().getUserConfig();
        config.set(CardSelectComboBox.class.getCanonicalName() + ".cbAutoComplete", this.cbAutoComplete.isSelected() ? "1" : "0");
        config.set(CardSelectComboBox.class.getCanonicalName() + ".cbFreeCardOnly", this.cbFreeCardOnly.isSelected() ? "1" : "0");
    }

    private void loadCheckBoxState() {
        Preferences config = ClientSetup.getInstance().getUserConfig();
        String cbac = config.get(CardSelectComboBox.class.getCanonicalName() + ".cbAutoComplete", null);
        this.cbAutoComplete.setSelected(cbac != null && "1".equals(cbac));
        String cbfc = config.get(CardSelectComboBox.class.getCanonicalName() + ".cbFreeCardOnly", null);
        this.cbFreeCardOnly.setSelected(cbfc != null && "1".equals(cbfc));
        this.cbFreeCardOnly.setEnabled(this.cbAutoComplete.isSelected());
    }

    public void refreshData() throws Exception {
        this.cardsItems = null;
        if (this.cbAutoComplete.isSelected()) {
            List cards = this.cbFreeCardOnly.isSelected() ? ((CardActionsService)this.context.getPort(CardActionsService.class)).getFreeCardNumbers() : ((CardActionsService)this.context.getPort(CardActionsService.class)).getAllCardNumbers();
            this.cardsItems = (String[])cards.stream().map(String::valueOf).toArray(String[]::new);
        }
        this.refillComboBox();
    }

    private void refillComboBox() {
        String text = this.comboBoxEditor.getText();
        this.comboBox.removeAllItems();
        this.comboBox.addItem(text);
        if (this.cardsItems == null) {
            return;
        }
        int minCharsForAutocomplete = this._getMinCharsForAutocomplete();
        if (text.length() < minCharsForAutocomplete) {
            this.comboBox.addItem("(\u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: " + minCharsForAutocomplete + ")");
            return;
        }
        for (String cardItem : this.cardsItems) {
            if (text != null && !text.isEmpty() && cardItem.indexOf(text) == -1) continue;
            this.comboBox.addItem(cardItem);
        }
    }

    private int _getMinCharsForAutocomplete() {
        if (this.cardsItems.length < 1000) {
            return 0;
        }
        if (this.cardsItems.length < 10000) {
            return 1;
        }
        if (this.cardsItems.length < 100000) {
            return 2;
        }
        return 3;
    }

    public void setValue(long value) {
        this.comboBoxEditor.setText(value > 0L ? String.valueOf(value) : "");
        this.refillComboBox();
    }

    public long getValue() {
        return !this.comboBoxEditor.getText().isEmpty() ? Long.parseLong(this.comboBoxEditor.getText()) : 0L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cbAutoComplete || e.getSource() == this.cbFreeCardOnly) {
            this.saveCheckBoxState();
            this.cbFreeCardOnly.setEnabled(this.cbAutoComplete.isSelected());
            try {
                this.refreshData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyChar() == '\u001b') {
            this.comboBox.hidePopup();
            return;
        }
        if (this.cbAutoComplete.isSelected() && e.getKeyCode() != 40 && e.getKeyCode() != 38) {
            int caretPosition = this.comboBoxEditor.getCaretPosition();
            String enteredText = this.comboBoxEditor.getText();
            if (!enteredText.equals(this.previousEnteredText)) {
                this.refillComboBox();
                this.comboBox.hidePopup();
                this.comboBox.showPopup();
                this.comboBoxEditor.setCaretPosition(caretPosition);
            }
            this.previousEnteredText = enteredText;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    private class CardSelectComboBoxRenderer
    extends DefaultListCellRenderer {
        private CardSelectComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int offset;
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String editorText = CardSelectComboBox.this.comboBoxEditor.getText();
            String itemText = label.getText();
            if (index == 0 || index == 1 && itemText.startsWith("(")) {
                String newText = "<html><font color='gray'>" + itemText + "</font></html>";
                label.setText(newText);
            } else if (!itemText.isEmpty() && !editorText.isEmpty() && (offset = itemText.indexOf(editorText)) != -1) {
                int length = editorText.length();
                String newText = "<html>" + itemText.substring(0, offset) + "<font color='red'>" + editorText + "</font>" + itemText.substring(offset + length) + "</html>";
                label.setText(newText);
            }
            return label;
        }
    }
}

