/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class TvAccountDetailDao {
    public static BigDecimal getAccount(Connection con, int moduleId, int tvAccountId, Set<Integer> sids, Date dateFrom, Date dateTo) throws BGException {
        try {
            GregorianCalendar utilCalendar = new GregorianCalendar();
            utilCalendar.setTime(dateFrom);
            int dayFrom = utilCalendar.get(5);
            utilCalendar.setTime(dateTo);
            int dayTo = utilCalendar.get(5);
            String tableName = ServerUtils.getModuleMonthTableName((String)"tv_account_detail", (Date)dateFrom, (int)moduleId);
            if (!ServerUtils.tableExists((Connection)con, (String)tableName)) {
                return BigDecimal.ZERO;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT SUM(account) FROM ").append(tableName).append(" WHERE accountId=?");
            if (sids != null && sids.size() > 0) {
                sb.append(" AND sid IN (").append(Utils.toString(sids)).append(")");
            }
            sb.append(" AND day>=? AND day<=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setInt(1, tvAccountId);
            ps.setInt(2, dayFrom);
            ps.setInt(3, dayTo);
            ResultSet rs = ps.executeQuery();
            BigDecimal result = rs.next() ? rs.getBigDecimal(1) : BigDecimal.ZERO;
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public static void checkTable(Connection con, String detailTable) throws SQLException {
        if (!ServerUtils.tableExists((Connection)con, (String)detailTable)) {
            Statement stmt = con.createStatement();
            stmt.executeUpdate("CREATE TABLE `" + detailTable + "` (  `contractId` int(11) NOT NULL,  `accountId` int(11) NOT NULL,  `productId` int(11) NOT NULL,  `sid` int(11) NOT NULL,  `day` int(11) NOT NULL,  `account` decimal(10,5) NOT NULL,  PRIMARY KEY (`contractId`,`accountId`,`productId`,`sid`,`day`)) /*!50100 PARTITION BY HASH (contractId)PARTITIONS 8 */");
            stmt.close();
        }
    }
}

