<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<div class="textFieldLabel mTop10">Вложения:</div>
<div class="flexRow" style="flex-wrap: wrap; justify-content: flex-start;">
	<c:forEach var="file" items="${files}">
	<div class="hdAttach" style="background-color: #eee; border: 1px solid #ddd; padding: 5px 10px; margin: 5px 10px; border-radius: 5px;">${file.title}
	<br>[<c:choose>
		<c:when test="${ file.size < 1024 }"><fmt:formatNumber value="${file.size}" groupingUsed="true"/> байт</c:when>
		<c:when test="${ file.size < 1024 * 1024 }"><fmt:formatNumber value="${file.size/1024}" groupingUsed="true" maxFractionDigits="1"/> Кбайт</c:when>
		<c:otherwise><fmt:formatNumber value="${file.size/(1024*1024)}" groupingUsed="true" maxFractionDigits="1"/> Mбайт</c:otherwise>
	</c:choose>] 
	</div>
	</c:forEach>
	<c:if test="${fn:length(files) < 5}">
	<div class="addAttach" onclick="document.querySelector('input[type=file]').click(); return false;">+</div>
	</c:if>
	<input type="file" style="display: none;" onchange="handleFile(this.files[0]); return false;">
</div>

<script>
	//let input = document.querySelector('input[type=file]');
	
	document.addEventListener('dragover', ev => ev.preventDefault());
	document.addEventListener('drop', ev => ev.preventDefault());
	document.querySelector('div.addAttach').addEventListener('drop', ev => 
	{
	    ev.preventDefault(); // отключаем поведение по умолчанию
	    //console.log(ev.dataTransfer); // смотрим на то, что получаем
	    // получаем следующее (в случае передачи изображения)
	    /*
	    DataTransfer {dropEffect: "none", effectAllowed: "all", items: DataTransferItemList, types: Array(1), files: FileList}
	        dropEffect: "none"
	        effectAllowed: "all"
	    =>  files: FileList
	            length: 0
	        __proto__: FileList
	        items: DataTransferItemList {length: 0}
	        types: []
	        __proto__: DataTransfer
	    */

	    // интересующий нас объект (File) хранится в свойстве "files" объекта "DataTransfer", извлекаем его
	    //file = ev.dataTransfer.files[0]

	    // проверяем
	    // log(file)
	    /*
	    File {name: "image.png", lastModified: 1593246425244, lastModifiedDate: Sat Jun 27 2020 13:27:05 GMT+0500 (Екатеринбург, стандартное время), webkitRelativePath: "", size: 208474, …}
	        lastModified: 1593246425244
	        lastModifiedDate: Sat Jun 27 2020 13:27:05 GMT+0500 (Екатеринбург, стандартное время) {}
	        name: "image.png"
	        size: 208474
	        type: "image/png"
	        webkitRelativePath: ""
	        __proto__: File
	    */

	    // передаем файл в функцию для дальнейшей обработки
	    // handleFile(file)
	    // alert( file );
	});

    // file = document.getElementById("image-file").files[0];
    // file = document.querySelector("input[type='file']").files[0];
	
	handleFile = async file => {
		let formData = new FormData();
		formData.append( "module", "ru.bitel.bgbilling.plugins.helpdesk" );
		formData.append( "action", "HelpDesk" );
		formData.append( "operation", "uploadFile" );
		formData.append( "messageUUID", "${messageUUID}" );
		formData.append( "file", file );
		let response = await fetch('${pageContext.request.contextPath}/webexecuter', {method: "POST", body: formData});
		if (response.ok)
		{
			let divEl = jQuery("div#hdAttach");
			if ( typeof divEl !== 'undefined' )
			{
				divEl.empty().html( await response.text() );
			}			
		}
		else
		{
			alert("Ошибка HTTP: " + response.status);
		}		
	}	

</script>    