/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.runtel.server.bean.RuntelManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

@WebServlet(name="RuntelExecutor", urlPatterns={"/runtel/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String ACTION_BALANCE = "balance";
    private static final String ACTION_RECEIPT_OF_FUNDS = "receipt_of_funds";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection con = null;
        try {
            con = this.setup.getDBConnectionFromPool();
            JSONObject jsonObject = new JSONObject(new String(Utils.readByBlock((InputStream)request.getInputStream())));
            Action action = this.getAction(jsonObject);
            JSONObject responseJsonObject = null;
            if (ACTION_BALANCE.equals(action.action)) {
                params = jsonObject.getJSONObject("params");
                int contractId = params.optInt("contract_bid", 0);
                BigDecimal balanceAmount = BigDecimal.ZERO;
                try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                    balanceAmount = balanceUtils.getBalance(LocalDate.now(), contractId);
                }
                responseJsonObject = RuntelManager.getResponse(action);
                responseJsonObject.put("code", (Object)String.valueOf(200));
                JSONObject bodyJSONObject = new JSONObject();
                bodyJSONObject.put("amount", balanceAmount.intValue());
                responseJsonObject.put("body", (Object)bodyJSONObject);
            } else if (ACTION_RECEIPT_OF_FUNDS.equals(action.action)) {
                params = jsonObject.getJSONObject("params");
                int contractId = params.optInt("contract_bid", 0);
                Period period = this.getPeriod(params);
                JSONArray paymentsJSONArray = new JSONArray();
                List payments = new PaymentDao(con).getPaymentList(contractId, period, 2).getList();
                for (Payment payment : payments) {
                    JSONObject paymentJsonObject = new JSONObject();
                    paymentJsonObject.put("dt_epoch", payment.getDate().getTime() / 1000L);
                    paymentJsonObject.put("amount", (Object)payment.getSum());
                    paymentsJSONArray.put((Object)paymentJsonObject);
                    Page page = action.getPage();
                    Page.setRecordCount((Page)page, (int)payments.size());
                }
                responseJsonObject = RuntelManager.getResponse(action);
                responseJsonObject.put("code", (Object)String.valueOf(200));
                responseJsonObject.put("list", (Object)paymentsJSONArray);
            } else {
                responseJsonObject = RuntelManager.getResponse(action);
                responseJsonObject.put("code", (Object)String.valueOf(200));
                responseJsonObject.put("error", (Object)(action.action + " not found"));
            }
            response.setContentType("application/json");
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(responseJsonObject.toString().getBytes("UTF-8"));
            outputStream.flush();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private Action getAction(JSONObject jsonObject) {
        Action action = new Action(this);
        action.action = jsonObject.getString("action");
        action.actionId = jsonObject.getString("action_id");
        action.obj = jsonObject.getString("obj");
        int limit = jsonObject.optInt("limit", -1);
        if (limit > 0) {
            int offset = jsonObject.optInt("offset", 0);
            action.page = new Page(offset < limit ? 1 : offset / limit + 1, limit);
        }
        return action;
    }

    private Period getPeriod(JSONObject params) {
        return new Period(params.optLong("start_epoch"), params.optLong("stop_epoch"));
    }

    public class Action {
        String action = null;
        String actionId = null;
        String obj = null;
        Page page = null;

        public Action(ModuleExecutor this$0) {
        }

        public String getAction() {
            return this.action;
        }

        public String getActionId() {
            return this.actionId;
        }

        public String getObj() {
            return this.obj;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

