/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyLogFileUtils;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.event.RequestLogInfoEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;

public class RequestLogInfoEventProcessor
implements EventListener<RequestLogInfoEvent> {
    private final DefaultServerSetup setup;

    public RequestLogInfoEventProcessor(Setup setup, Accounting accounting) throws Exception {
        this.setup = setup;
        if (InetUtils.checkAccountingRootDeviceId(setup, accounting.moduleId)) {
            EventProcessor.getInstance().addListener((EventListener)this, RequestLogInfoEvent.class, accounting.moduleId, "accountingRootDeviceId=" + accounting.rootDeviceId);
        } else {
            EventProcessor.getInstance().addListener((EventListener)this, RequestLogInfoEvent.class, accounting.moduleId, RequestLogInfoEventProcessor.getQuery((DefaultServerSetup)setup, accounting));
        }
    }

    public void notify(RequestLogInfoEvent requestLogInfoEvent, EventListenerContext ctx) throws BGException {
        requestLogInfoEvent.addLogs(HourlyLogFileUtils.getLogExistsForMonth((ParameterMap)this.setup, (String)"datalog.flow.dir", (Date)requestLogInfoEvent.getMonth(), (int)requestLogInfoEvent.getDeviceId()));
        requestLogInfoEvent.addLogs(HourlyLogFileUtils.getLogExistsForMonth((ParameterMap)this.setup, (String)"datalog.radius.dir", (Date)requestLogInfoEvent.getMonth(), (int)requestLogInfoEvent.getDeviceId()));
    }

    private static String getQuery(DefaultServerSetup setup, Accounting accounting) throws Exception {
        Set<Integer> childrenDeviceIds;
        if (accounting != null && accounting.childrenDeviceIds != null) {
            childrenDeviceIds = accounting.childrenDeviceIds;
        } else {
            int rootDeviceId = setup.getInt("rootDeviceId", 0);
            InetDeviceMap deviceMap = InetDeviceMap.getInstance(SetupParam.getModuleId((ParameterMap)setup));
            childrenDeviceIds = deviceMap.get(rootDeviceId).getDescendantIds();
            childrenDeviceIds = new HashSet<Integer>(childrenDeviceIds);
            childrenDeviceIds.add(rootDeviceId);
        }
        StringBuilder sb = new StringBuilder(20).append('(');
        for (Integer id : childrenDeviceIds) {
            sb.append("deviceId=").append(id).append(" OR ");
        }
        sb.setLength(sb.length() - 4);
        sb.append(')');
        return sb.toString();
    }
}

