/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.client;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.dba.client.ConfigureTree;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ConfigureTreeNode
extends DefaultMutableTreeNode {
    private static Icon rootIcon = ClientUtils.getIcon((String)"folder.png");
    private static Icon moduleIcon = ClientUtils.getIcon((String)"folder.png");
    private static Icon groupIcon = ClientUtils.getIcon((String)"folder.png");
    private static Icon tableIcon = ClientUtils.getIcon((String)"table.png");
    private ConfigureTree tree;
    private Map<String, String> configMap;
    private String moduleId;
    private String tableId;
    private Element ref;
    private Element defaultEl;
    private String config;
    public static final int TYPE_ROOT = 1;
    public static final int TYPE_MODULE = 2;
    public static final int TYPE_GROUP = 3;
    public static final int TYPE_TABLE = 4;
    private int type;

    public ConfigureTreeNode(ConfigureTree tree) {
        this.tree = tree;
    }

    public void loadNode() throws Exception {
        NodeList childList = this.ref.getChildNodes();
        int size = childList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = childList.item(i);
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            ConfigureTreeNode childNode = new ConfigureTreeNode(this.tree);
            childNode.setRef(el);
            childNode.setConfigMap(this.configMap);
            childNode.setModuleId(this.moduleId);
            String name = el.getNodeName();
            if (name.equals("table")) {
                childNode.setType(4);
                childNode.setTableId(el.getAttribute("id"));
                childNode.setConfig(Utils.maskNull((String)this.configMap.get(childNode.getModuleId() + "_" + childNode.getTableId())));
                childNode.setDefaultEl(XMLUtils.selectElement((Node)el, (String)"default"));
            } else if (name.equals("group")) {
                childNode.setType(3);
            } else {
                if (!name.equals("module")) continue;
                childNode.setType(2);
                childNode.setModuleId(el.getAttribute("id"));
            }
            this.add(childNode);
            childNode.loadNode();
        }
    }

    public JLabel getView() {
        JLabel view = new JLabel();
        view.setPreferredSize(new Dimension(800, 20));
        switch (this.type) {
            case 1: {
                view.setIcon(rootIcon);
                view.setText("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446");
                break;
            }
            case 2: {
                view.setIcon(moduleIcon);
                view.setText(this.ref.getAttribute("title"));
                break;
            }
            case 3: {
                view.setIcon(groupIcon);
                view.setText(this.ref.getAttribute("title"));
                break;
            }
            default: {
                StringBuilder text = new StringBuilder(100);
                text.append(this.ref.getAttribute("title"));
                ParameterMap data = this.getData();
                text.append(" (\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043c\u0435\u0441.: ");
                text.append(data.get("store_month"));
                text.append("; \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c: ");
                text.append(data.get("save_before_delete"));
                text.append(")");
                view.setIcon(tableIcon);
                view.setText(text.toString());
            }
        }
        return view;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Element getRef() {
        return this.ref;
    }

    public void setRef(Element ref) {
        this.ref = ref;
    }

    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, String> config) {
        this.configMap = config;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Element getDefaultEl() {
        return this.defaultEl;
    }

    public void setDefaultEl(Element defaultEl) {
        this.defaultEl = defaultEl;
    }

    public ParameterMap getData() {
        Object result = null;
        result = Utils.notBlankString((String)this.config) ? new ParameterMap.DefaultParameterMap(Utils.stringToPairsHash((String)this.config)) : (this.defaultEl != null ? XMLUtils.attributesToParameterMap((Element)this.defaultEl) : new ParameterMap.DefaultParameterMap(new HashMap()));
        return result;
    }
}

