/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.modules.bill.common.bean.InvoiceDocument;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractBillDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.Page;

public class InvoiceDocumentDao
extends AbstractBillDao {
    public InvoiceDocumentDao(Setup setup, ParameterMap moduleSetup, Connection con, int moduleId) {
        super(setup, moduleSetup, con, moduleId, "bill_invoice_data_" + moduleId);
    }

    public static <I> List<I> getInvoiceDocumentList(Connection con, int moduleId, String table, int contractId, boolean onlyReady, Page page, Function<ResultSet, I> converter) throws SQLException {
        ArrayList<I> result = new ArrayList<I>();
        String query = "SELECT SQL_CALC_FOUND_ROWS bill_data.*, type.title FROM " + table + " AS bill_data LEFT JOIN bill_doc_type_" + moduleId + " AS type ON bill_data.type=type.id WHERE cid=? " + (onlyReady ? "AND show_ready=1 " : "") + "ORDER BY yy DESC, mm DESC, number DESC " + Page.toSqlLimit((Page)page);
        try (PreparedStatement ps = con.prepareStatement(query.toString(), 1);){
            int index = 1;
            ps.setInt(index++, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(converter.apply(rs));
                }
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)con));
        }
        return result;
    }

    public List<InvoiceDocument> list(int contractId, boolean onlyReady, Page page) throws BGException {
        try {
            return InvoiceDocumentDao.getInvoiceDocumentList(this.con, this.moduleId, this.tableName, contractId, onlyReady, page, rs -> {
                try {
                    return InvoiceDocumentDao.getInvoiceDocumentFromRS(rs, false, true);
                }
                catch (SQLException ex) {
                    throw new BGRuntimeException((Throwable)ex);
                }
            });
        }
        catch (SQLException | BGRuntimeException ex) {
            Throwable t = ex;
            if (t.getCause() instanceof SQLException) {
                t = ex.getCause();
            }
            throw new BGException(t);
        }
    }

    private static InvoiceDocument getInvoiceDocumentFromRS(ResultSet rs, boolean loadContract, boolean loadType) throws SQLException {
        InvoiceDocument result = new InvoiceDocument();
        result.setNumberFormatted(rs.getString("format_number"));
        result.setNumber(rs.getInt("number"));
        result.setNumberInMonth(rs.getInt("number_in_month"));
        result.setNumberInYear(rs.getInt("number_in_year"));
        result.setDocumentSpecId(rs.getInt("type"));
        int id = rs.getInt("id");
        result.setId(id);
        result.setContractId(rs.getInt("cid"));
        if (loadContract) {
            result.setContractTitle(rs.getString("contract.title"));
            result.setContractComment(rs.getString("contract.comment"));
        }
        if (loadType) {
            result.setDocumentSpecTitle(rs.getString("type.title"));
        }
        result.setUnloadStatus(rs.getInt("unload_status"));
        result.setYear(rs.getInt("yy"));
        result.setMonth(rs.getInt("mm"));
        result.setDateCreated((Date)rs.getDate("create_dt"));
        result.setTotal(rs.getBigDecimal("summ"));
        result.setShowReady(rs.getBoolean("show_ready"));
        return result;
    }
}

