/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class BGControlPanelCategorySubcategory
extends JPanel {
    public static final String PROPERTY_NAME_CHANGE_DATA = "changeData";
    List<String[]> categoryList;
    List<String[]> subcategoryList;
    String[] selectedCategory;
    String[] selectedSubcategory;
    Popup popup;
    JButton button = new JButton(){
        {
            this.addActionListener(e -> BGControlPanelCategorySubcategory.this.setPopupVisible(true));
        }
    };

    public BGControlPanelCategorySubcategory() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.button, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setPopupVisible(boolean visible) {
        this.popup = new Popup();
        this.popup.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals(PROPERTY_NAME_CHANGE_DATA)) {
                this.selectedCategory = this.popup.newCategory;
                this.selectedSubcategory = this.popup.newSubcategory;
                this.popup.setVisible(false);
                this.popup = null;
                if (this.selectedCategory != null && this.selectedSubcategory != null) {
                    this.button.setText(this.selectedCategory[1] + " / " + this.selectedSubcategory[1]);
                    this.firePropertyChange(PROPERTY_NAME_CHANGE_DATA, false, true);
                }
            }
        });
        this.popup.setData(this.categoryList, this.selectedCategory, true);
        this.popup.setData(this.subcategoryList, this.selectedSubcategory, false);
        this.popup.show(this.button, 0, this.button.getHeight() + 1);
    }

    public void setData(List<String> categorySubcategoryIds, List<IdTitle> categoryList, List<IdTitle> subcategoryList, String currentCategoryId, String currentSubcategoryId) {
        this.categoryList = new ArrayList<String[]>();
        for (IdTitle idTitle : categoryList) {
            String[] data;
            String id = String.valueOf(idTitle.getId());
            List ids = categorySubcategoryIds.stream().map(a -> Utils.toList(a)).filter(a -> ((String)a.get(0)).equals(id)).findFirst().orElse(new ArrayList());
            if (!ids.isEmpty()) {
                ids.remove(0);
            }
            if ((data = new String[]{id, idTitle.getTitle(), Utils.toString(ids)})[0].equals(currentCategoryId)) {
                this.selectedCategory = data;
            }
            this.categoryList.add(data);
        }
        this.subcategoryList = new ArrayList<String[]>();
        for (IdTitle idTitle : subcategoryList) {
            String[] data = new String[]{String.valueOf(idTitle.getId()), idTitle.getTitle()};
            if (data[0].equals(currentSubcategoryId)) {
                this.selectedSubcategory = data;
            }
            this.subcategoryList.add(data);
        }
        if (this.selectedCategory != null && this.selectedSubcategory != null) {
            this.button.setText(this.selectedCategory[1] + " / " + this.selectedSubcategory[1]);
        } else {
            this.button.setText("\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 / \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
        }
    }

    public String[] getSelectedCategory() {
        return this.selectedCategory;
    }

    public String[] getSelectedSubcategory() {
        return this.selectedSubcategory;
    }

    private class Popup
    extends JPopupMenu {
        JPanel categoryPanel = new JPanel();
        JPanel subcategoryPanel = new JPanel();
        String[] oldCategory = new String[0];
        String[] oldSubcategory = new String[0];
        String[] newCategory = new String[0];
        String[] newSubcategory = new String[0];
        Color color = UIManager.getColor("List.selectionBackground");
        MouseListener categoryMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                Object source = event.getSource();
                if (source instanceof ItemLabel) {
                    ItemLabel label = (ItemLabel)source;
                    for (Component component : label.getParent().getComponents()) {
                        component.setBackground(Color.WHITE);
                    }
                    label.setBackground(Popup.this.color);
                    Popup.this.newCategory = label.data;
                    String[] subcategoryIds = label.data[2].split(",");
                    for (Component component : Popup.this.subcategoryPanel.getComponents()) {
                        if (!(component instanceof ItemLabel)) continue;
                        label = (ItemLabel)component;
                        String labelId = label.data[0];
                        boolean visible = false;
                        for (String id : subcategoryIds) {
                            if (!id.equals(labelId)) continue;
                            visible = true;
                            break;
                        }
                        label.setVisible(visible);
                    }
                }
            }
        };
        MouseListener subcategoryMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                Object source = event.getSource();
                if (source instanceof ItemLabel) {
                    ItemLabel label = (ItemLabel)source;
                    for (Component component : label.getParent().getComponents()) {
                        component.setBackground(Color.WHITE);
                    }
                    label.setBackground(Popup.this.color);
                    Popup.this.newSubcategory = label.data;
                }
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                Popup.this.changeData();
            }
        };

        public Popup() {
            this.categoryPanel.setLayout(new GridBagLayout());
            this.categoryPanel.setBackground(Color.WHITE);
            this.categoryPanel.setOpaque(true);
            this.subcategoryPanel.setLayout(new GridBagLayout());
            this.subcategoryPanel.setBackground(Color.WHITE);
            this.subcategoryPanel.setOpaque(true);
            this.setLayout(new GridLayout(1, 2));
            this.setPopupSize(500, 300);
            this.add(this.getPanel("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f:", this.categoryPanel));
            this.add(this.getPanel("\u041f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f:", this.subcategoryPanel));
        }

        private JPanel getPanel(String title, JPanel scrollPanel) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel(title), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(scrollPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private void setData(List<String[]> list, String[] selected, boolean isCategory) {
            JPanel panel = isCategory ? this.categoryPanel : this.subcategoryPanel;
            panel.removeAll();
            int y = 0;
            if (list != null) {
                List<Object> ids = new ArrayList();
                if (isCategory) {
                    this.newCategory = selected;
                    this.oldCategory = selected;
                } else {
                    this.newSubcategory = selected;
                    this.oldSubcategory = selected;
                    if (this.oldCategory != null) {
                        ids = Utils.toList(this.oldCategory[2]);
                    }
                }
                for (String[] item : list) {
                    ItemLabel label = new ItemLabel(item);
                    if (item.equals(selected)) {
                        label.setBackground(this.color);
                    }
                    boolean visible = isCategory ? !item[2].isEmpty() : ids.contains(item[0]);
                    label.setVisible(visible);
                    label.addMouseListener(isCategory ? this.categoryMouseListener : this.subcategoryMouseListener);
                    panel.add((Component)label, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
            }
            panel.add(Box.createGlue(), new GridBagConstraints(0, y++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void changeData() {
            if (!this.newCategory.equals(this.oldCategory) || !this.newSubcategory.equals(this.oldSubcategory)) {
                this.firePropertyChange(BGControlPanelCategorySubcategory.PROPERTY_NAME_CHANGE_DATA, false, true);
            }
        }
    }

    class ItemLabel
    extends JLabel {
        String[] data;

        public ItemLabel(String[] data) {
            super(data[1]);
            this.data = null;
            this.data = data;
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        }
    }
}

