/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.bgbilling.kernel.generator.common.bean.BGGenerator;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class PatternGeneratorTab
extends BGUPanel {
    private List<IdTitle> sequenceItems = new ArrayList<IdTitle>();
    private PatternGeneratorTableModel tableModel = new PatternGeneratorTableModel();

    @Override
    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.tableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit(table, this);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if ("refreshTab".equals(e.getActionCommand()) && !this.tableModel.getRows().isEmpty()) {
                return;
            }
            this.sequenceItems = ((ClientContext)this.getContext()).getWebService(ContractPatternService.class, 0).patternSequenceTitles();
            this.tableModel.setData(((ClientContext)this.getContext()).getWebService(ContractPatternService.class, 0).patternGeneratorList());
        });
        new AbstractBGUPanel.BGActionNew(e -> new PatternGeneratorEditor("\u041d\u043e\u0432\u044b\u0439 \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440", new BGGenerator()).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.tableModel.optSelectedRow().ifPresentOrElse(g -> new PatternGeneratorEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430", (BGGenerator)g).open(), () -> ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
        new AbstractBGUPanel.BGActionDelete(e -> {
            BGGenerator generator = (BGGenerator)this.tableModel.getSelectedRow();
            if (generator == null) {
                ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete(generator.getTitle())) {
                ((ClientContext)this.getContext()).getWebService(ContractPatternService.class, 0).patternGeneratorDelete(generator.getId());
            }
        });
    }

    class PatternGeneratorTableModel
    extends BGTableModel<BGGenerator> {
        public PatternGeneratorTableModel() {
            super(PatternGeneratorTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0428\u0430\u0431\u043b\u043e\u043d", 100, 400, 800, "pattern", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", 100, 400, 800, "sequence", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValueAt(BGGenerator val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("sequence".equals(identifier)) {
                return PatternGeneratorTab.this.sequenceItems.stream().filter(a -> a.getId() == val.getSequenceId()).findFirst().map(a -> a.getTitle()).orElse("");
            }
            return super.getValueAt(val, column);
        }
    }

    class PatternGeneratorEditor
    extends BGEditorDialog<BGGenerator> {
        private BGTextField title;
        private BGTextField pattern;
        private BGTextArea samples;
        private BGUComboBox<IdTitle> sequence;

        public PatternGeneratorEditor(String title, BGGenerator data) {
            super(title, data);
            this.title = new BGTextField(40);
            this.pattern = new BGTextField(40);
            this.samples = new BGTextArea(10, 40);
            this.sequence = new BGUComboBox();
        }

        @Override
        public void doDialogPanel() {
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", this.title);
            this.addFieldV("\u0428\u0430\u0431\u043b\u043e\u043d:", this.pattern);
            this.addFieldV("\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c:", this.sequence);
            this.addFieldV("\u041f\u0440\u0438\u043c\u0435\u0440\u044b \u0448\u0430\u0431\u043b\u043e\u043d\u0430:", BGSwingUtilites.wrapScrollPane(this.samples, 700, 300));
            ArrayList<IdTitle> sequenceItems = new ArrayList<IdTitle>();
            sequenceItems.add(IdTitle.NO_SELECT);
            this.tryCall(() -> sequenceItems.addAll(((ClientContext)PatternGeneratorTab.this.getContext()).getWebService(ContractPatternService.class, 0).patternSequenceTitles()));
            this.sequence.setData(sequenceItems);
            if (((BGGenerator)this.data).getId() > 0) {
                this.tryCall(() -> {
                    this.data = ((ClientContext)PatternGeneratorTab.this.getContext()).getWebService(ContractPatternService.class, 0).patternGeneratorGet(((BGGenerator)this.data).getId());
                });
            }
            this.samples.setEditable(false);
            this.samples.setText("${NX}\n${NX}-${Y2}\n${Y2}${NRX}\nD${Y4}${time:MM}-${NRX}\n\n\n    ${NX} - \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, X - \u0446\u0438\u0444\u0440\u0430. \u041f\u043e\u0434\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0443\u0434\u0435\u0442 \u0437\u0430\u043c\u0435\u043d\u0435\u043d\u0430 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0442\u0430\u043a\u043e\u0433\u043e \u0442\u0438\u043f\u0430, \u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b\u043c \u0441\u043b\u0435\u0432\u0430 \u043d\u0443\u043b\u044f\u043c\u0438 \u0434\u043e \u0434\u043b\u0438\u043d\u044b X;\n\n    ${Y2} - \u0434\u0432\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0446\u0438\u0444\u0440\u044b \u0433\u043e\u0434\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430;\n\n    ${Y4} - \u0447\u0435\u0442\u044b\u0440\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0446\u0438\u0444\u0440\u044b \u0433\u043e\u0434\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430;\n\n    ${time:<format>} - \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0432\u043c\u0435\u0441\u0442\u043e <format> \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0430 \u043c\u0430\u043a\u0440\u043e\u0441\u0430 \u0441 yy - \u0434\u0432\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0446\u0438\u0444\u0440\u044b \u0433\u043e\u0434\u0430, yyyy - \u0447\u0435\u0442\u044b\u0440\u0435 \u0446\u0438\u0444\u0440\u044b \u0433\u043e\u0434\u0430, MM - \u043c\u0435\u0441\u044f\u0446, dd - \u0434\u0435\u043d\u044c \u043c\u0435\u0441\u044f\u0446\u0430.;\n\n    ${NRX} - \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0433\u0434\u0435 \u0425 - \u0447\u0438\u0441\u043b\u043e \u0440\u0430\u0437\u0440\u044f\u0434\u043e\u0432 \u0432 \u043d\u043e\u043c\u0435\u0440\u0435 (\u0430\u043d\u0430\u043b\u043e\u0433\u0438\u0447\u043d\u043e ${NX}-\u043f\u043e\u0434\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435). \u041e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0444\u043e\u0440\u043c\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u043c \u043e\u0431\u0440\u0430\u0437\u043e\u043c: \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u044e\u0442\u0441\u044f \u0432\u0441\u0435 \u043f\u0440\u043e\u0447\u0438\u0435 \u043f\u043e\u0434\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0442\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430), \u0437\u0430\u0442\u0435\u043c \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0432 \u0431\u0430\u0437\u0435 \u0441 \u0442\u0430\u043a\u0438\u043c \"\u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c\" \u0438\u043c\u0435\u043d\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0431\u0435\u0440\u0435\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u0440\u0435\u0434\u0438 \u043f\u043e\u0434\u043e\u0431\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0438 \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443, \u043f\u043e\u0441\u043b\u0435 \u0447\u0435\u0433\u043e \u043f\u043e\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0435\u043f\u043e\u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0435\u043d\u043d\u043e \u0432 \u0438\u043c\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. \u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0435\u0441\u043b\u0438 \u0448\u0430\u0431\u043b\u043e\u043d \u0438\u043c\u0435\u043d\u0438 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043a\u0430\u043a \"D${Y4}${time:MM}${time:dd}-${NR4}\", \u0442\u043e \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0437\u0430 \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u0441\u0443\u0442\u043a\u0438 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, 01.01.2009) \u0434\u0432\u0443\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u043f\u043e\u043b\u0443\u0447\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u0430, \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e, D20090101-0001 \u0438 D20090101-0002, \u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043d\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u043e \u044d\u0442\u043e\u043c\u0443 \u0436\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0443 \u043d\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0441\u0443\u0442\u043a\u0438 \u043f\u043e\u043b\u0443\u0447\u0438\u043c \u043d\u043e\u043c\u0435\u0440 D20090102-0001.");
            this.samples.setCaretPosition(0);
            this.title.setText(((BGGenerator)this.data).getTitle());
            this.pattern.setText(((BGGenerator)this.data).getPattern());
            this.sequence.setSelectedItem(sequenceItems.stream().filter(a -> a.getId() == ((BGGenerator)this.data).getSequenceId()).findFirst().orElse((IdTitle)sequenceItems.get(0)));
        }

        @Override
        public boolean doApply() throws Exception {
            if (Utils.isBlankString(this.pattern.getText())) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d");
                return false;
            }
            ((BGGenerator)this.data).setTitle(this.title.getText());
            ((BGGenerator)this.data).setPattern(this.pattern.getText());
            ((BGGenerator)this.data).setSequenceId(((IdTitle)this.sequence.getSelectedItem()).getId());
            ((ClientContext)PatternGeneratorTab.this.getContext()).getWebService(ContractPatternService.class, 0).patternGeneratorUpdate((BGGenerator)this.data);
            PatternGeneratorTab.this.performAction("refresh");
            return true;
        }
    }
}

