/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.util.Calendar;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class PeriodTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<?>, TariffContext> {
    private final Calendar date1;
    private final Calendar date2;

    public PeriodTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.date1 = TimeUtils.parseCalendar((String)parameterMap.get("date1", null), (String)"dd.MM.yyyy");
        this.date2 = TimeUtils.parseCalendar((String)parameterMap.get("date2", null), (String)"dd.MM.yyyy");
    }

    @Override
    public int executeImpl(Long treeNodeId, AbstractTariffRequest<?> req, TariffContext context) {
        Calendar date = req.getTime();
        if (date != null && (this.date1 == null || TimeUtils.dateBeforeOrEq((Calendar)this.date1, (Calendar)date)) && (this.date2 == null || TimeUtils.dateBeforeOrEq((Calendar)date, (Calendar)this.date2))) {
            return 1;
        }
        if (req.isInfoEnabled()) {
            req.addInfo("Not accepted on period 2 date=" + TimeUtils.formatDate((Calendar)date) + "; date1=" + TimeUtils.formatDate((Calendar)this.date1) + "; date2=" + TimeUtils.formatDate((Calendar)this.date2) + "\n");
        }
        return 0;
    }
}

