/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RecordAction;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RequestRecordLog;

public class UserActionRecorderCache {
    private static final UserActionRecorderCache instance = new UserActionRecorderCache();
    private final Map<Integer, RequestRecordLog> recordingInProgress = new HashMap<Integer, RequestRecordLog>();
    private final Map<Integer, RequestRecordLog> finished = new HashMap<Integer, RequestRecordLog>();

    public static UserActionRecorderCache getInstance() {
        return instance;
    }

    public void recIfEnable(int userId, String moduleId, String service, String operation, String title, String actionId) {
        RequestRecordLog recordingActionsResult = this.recordingInProgress.get(userId);
        if (recordingActionsResult == null) {
            return;
        }
        recordingActionsResult.addRecordAction(new RecordAction(moduleId, title, operation, service, actionId));
    }

    public RequestRecordLog stopRecording(int userId) {
        RequestRecordLog entry = this.recordingInProgress.get(userId);
        entry.setEndRecordingTime(new Date());
        this.finished.put(userId, entry);
        this.recordingInProgress.remove(userId);
        return entry;
    }

    public Map<Integer, RequestRecordLog> getInProgress() {
        return this.recordingInProgress;
    }

    public Map<Integer, RequestRecordLog> getFinished() {
        return this.finished;
    }
}

