/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.ActionDirectoryBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class ActionUpdateAddressHouse
extends ActionDirectoryBase {
    @Override
    public void doAction() throws Exception {
        int houseNumber = -1;
        String houseFrac = "";
        String houseAndFrac = this.getParameter("houseAndFrac", null);
        if (houseAndFrac != null) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < houseAndFrac.length(); ++i) {
                char ch = houseAndFrac.charAt(i);
                if (!Character.isDigit(ch)) {
                    houseFrac = houseAndFrac.substring(i);
                    break;
                }
                str.append(ch);
            }
            houseNumber = Utils.parseInt((String)str.toString(), (int)0);
        }
        String id = this.getParameter("id");
        int streetId = this.getIntParameter("streetid", -1);
        int areaId = this.getIntParameter("areaid", -1);
        int quarterId = this.getIntParameter("quarterid", -1);
        int house = this.getIntParameter("house", houseNumber);
        String boxIndex = this.getParameter("box_index", "");
        int amount = this.getIntParameter("amount", 0);
        String frac = this.getParameter("frac", houseFrac);
        String comment = this.getParameter("comment", "");
        if (id == null || streetId == -1 || house == -1 || amount == -1) {
            throw new BGIllegalArgumentException();
        }
        int houseId = this.getHouseId(streetId, house, frac);
        if (houseId > 0 && Utils.parseInt((String)id) != houseId) {
            throw new BGMessageException("\u0414\u043e\u043c \u0443\u0436\u0435 \u0438\u043c\u0435\u0435\u0442\u0441\u044f");
        }
        House addressHouse = House.builder().setId(Utils.parseInt((String)id, (int)-1)).setAreaId(areaId).setQuarterId(quarterId).setStreetId(streetId).setHouse(house).setFrac(frac).setPostIndex(boxIndex).setAmount(amount).setComment(comment).build();
        try (HouseDao houseDao = new HouseDao(this.con);){
            houseDao.update(addressHouse);
            if (addressHouse.getId() <= 0) {
                this.createElement(this.rootNode, "address").setAttribute("hid", String.valueOf(addressHouse.getId()));
            } else {
                AddressUtils.onUpdateHouse(this.setup, addressHouse.getId());
            }
        }
    }

    private int getHouseId(int streetid, int house, String frac) throws SQLException {
        ResultSet rs;
        int index = 1;
        int houseId = 0;
        StringBuffer query = new StringBuffer();
        query.append("SELECT id FROM address_house WHERE streetid=? AND house=?");
        if (frac.startsWith("/")) {
            query.append(" AND ( frac=? OR frac=? )");
        } else {
            query.append(" AND frac=? ");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(index++, streetid);
        ps.setInt(index++, house);
        ps.setString(index++, frac);
        if (frac.startsWith("/")) {
            ps.setString(index++, frac.substring(1));
        }
        if ((rs = ps.executeQuery()).next()) {
            houseId = rs.getInt(1);
        }
        rs.close();
        ps.close();
        return houseId;
    }
}

