/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.collector;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceSelector;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogWriter;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogEntry;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.common.model.Idable;

class FlowListenerWorkerContext<A extends FlowArray<?>>
extends ServerContext {
    private static final Logger logger = LogManager.getLogger();
    protected final Accounting accounting;
    protected final FlowAgentInterfaceSelector ifaceSelector;
    protected final IPHourlyDataLogger dataLogger;
    private long currentHourPart = Long.MIN_VALUE;
    private ConcurrentHashMap<Integer, IPHourlyDataLogEntry> hourEntryMap;
    protected final WeakHashMap<IPHourlyDataLogEntry, IPDataLogWriter> writerMap = new WeakHashMap();
    protected final A flowArray;
    public static final int FLOW_FILTER_NONE = 0;
    public static final int FLOW_FILTER_RESOURCE = 1;
    public static final int FLOW_FILTER_RESOURCE_WITH_TIME = 2;
    public static final int FLOW_FILTER_RESOURCE_2 = 3;
    public static final int FLOW_FILTER_RESOURCE_WITH_TIME_2 = 4;
    public static final int FLOW_FILTER_PROCESS = 5;
    protected final int flowFilter;
    protected final Set<Integer> processAgentDeviceIds;

    public FlowListenerWorkerContext(Accounting accounting, FlowAgentInterfaceSelector ifaceSelector, Set<Integer> processAgentDeviceIds, int flowFilter, IPHourlyDataLogger dataLogger, A flowArray) {
        super(accounting.setup, accounting.moduleId, 0);
        this.accounting = accounting;
        this.ifaceSelector = ifaceSelector;
        this.flowFilter = flowFilter;
        this.processAgentDeviceIds = processAgentDeviceIds == null || processAgentDeviceIds.size() == 0 ? null : processAgentDeviceIds;
        this.dataLogger = dataLogger;
        this.flowArray = flowArray;
    }

    public void writeRecord(FlowPacket packet, long millis, Long hour, Idable source) {
        Long hourPart = millis / this.dataLogger.hourPart * this.dataLogger.hourPart;
        if (hourPart != this.currentHourPart) {
            this.hourEntryMap = this.dataLogger.getForHourPart(hourPart);
            this.currentHourPart = hourPart;
        }
        IPDataLogWriter writer = (IPDataLogWriter)this.dataLogger.getWriter(this.hourEntryMap, this.writerMap, hour.longValue(), source);
        try {
            writer.writeRecord(packet.data, millis);
        }
        catch (Exception e) {
            logger.error("IOException", (Throwable)e);
        }
    }

    public Map<DataLog.Parameter<?>, Object> getParameters() {
        return null;
    }
}

