/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.inet;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.RangeSet2;
import ru.bitel.common.util.Ranger;
import ru.bitel.common.util.SegmentedRangeSet;

public class IpAddressRangeSetEntry<R>
extends SegmentedRangeSet<IpAddress, byte[], R> {
    protected static final Comparator<byte[]> COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return IpAddress.compare(o1, o2);
        }
    };
    protected final IpAddressSegmenter<R> segmenter;

    public IpAddressRangeSetEntry(Class<R> clazz, Ranger<R, byte[]> ranger, boolean bites, int maskLength) {
        super(clazz, byte[].class, COMPARATOR, ranger, bites ? new BitsIpAddressSegmenter<R>(ranger, maskLength) : new IpAddressSegmenter<R>(ranger, maskLength));
        this.segmenter = (IpAddressSegmenter)((SegmentedRangeSet)this).segmenter;
    }

    @Override
    public R get(IpAddress segment, byte[] key) {
        return super.get(segment, key);
    }

    @Override
    public R get(IpAddress segmentKey, byte[] key, Matcher<R> matcher) {
        return super.get(segmentKey, key, matcher);
    }

    public RangeSet2<R, byte[]> segment(IpAddress segmentKey) {
        return (RangeSet2)this.segments.get(segmentKey);
    }

    public RangeSet2<R, byte[]> notSegmented() {
        return this.notSegmented;
    }

    public void addAll(IpAddress key, Set<R> set) {
        RangeSet2 newRangeSet;
        RangeSet2<R, byte[]> rangeSet = (RangeSet2<R, byte[]>)this.segments.get(key);
        if (rangeSet == null && (rangeSet = this.segments.putIfAbsent(key, newRangeSet = new RangeSet2(this.ranger, this.comparator, this.clazz, byte[].class))) == null) {
            rangeSet = newRangeSet;
        }
        rangeSet.addAll(set);
    }

    public void removeAll(IpAddress key, Set<R> set) {
        RangeSet2 rangeSet = (RangeSet2)this.segments.get(key);
        if (rangeSet == null) {
            return;
        }
        rangeSet.removeAll(set);
    }

    static class BitsIpAddressSegmenter<R>
    extends IpAddressSegmenter<R> {
        private final int maskLengthBites;
        private final int maskLengthPadding;

        BitsIpAddressSegmenter(Ranger<R, byte[]> ranger, int maskLength) {
            super(ranger, maskLength / 8);
            this.maskLengthBites = maskLength;
            this.maskLengthPadding = this.maskLengthBites - this.maskLength * 8;
        }

        @Override
        public byte[] segmentKey(byte[] address) {
            byte[] segmentKey = Arrays.copyOf(address, address.length - this.maskLength);
            for (int i = 0; i < this.maskLengthPadding; ++i) {
                int n = segmentKey.length - i / 8 - 1;
                segmentKey[n] = (byte)(segmentKey[n] & ~(1 << i % 8));
            }
            return segmentKey;
        }

        @Override
        public IpAddress segmentKey(R serv) {
            byte[] addressFrom = (byte[])this.ranger.getMinValue(serv);
            byte[] addressTo = (byte[])this.ranger.getMaxValue(serv);
            int length = addressFrom.length - this.maskLength;
            for (int i = length - 1; i >= 0; --i) {
                if (addressFrom[i] == addressTo[i]) continue;
                return null;
            }
            byte[] addressMaskFrom = Arrays.copyOf(addressFrom, length);
            byte[] addressMaskTo = Arrays.copyOf(addressTo, length);
            for (int i = 0; i < this.maskLengthPadding; ++i) {
                int n = addressFrom.length - i / 8 - 1;
                addressMaskFrom[n] = (byte)(addressMaskFrom[n] & ~(1 << i % 8));
                int n2 = addressMaskTo.length - i / 8 - 1;
                addressMaskTo[n2] = (byte)(addressMaskTo[n2] & ~(1 << i % 8));
            }
            if (IpAddress.equals(addressMaskFrom, addressMaskTo)) {
                return new IpAddress(addressMaskFrom);
            }
            return null;
        }
    }

    public static class IpAddressSegmenter<R>
    implements SegmentedRangeSet.Segmenter<IpAddress, R> {
        protected final int maskLength;
        protected final Ranger<R, byte[]> ranger;

        IpAddressSegmenter(Ranger<R, byte[]> ranger, int maskLength) {
            this.ranger = ranger;
            this.maskLength = maskLength;
        }

        @Override
        public byte[] segmentKey(byte[] address) {
            return Arrays.copyOf(address, address.length - this.maskLength);
        }

        @Override
        public IpAddress segmentKey(R serv) {
            byte[] addressFrom = this.ranger.getMinValue(serv);
            byte[] addressTo = this.ranger.getMaxValue(serv);
            int length = addressFrom.length - this.maskLength;
            for (int i = length - 1; i >= 0; --i) {
                if (addressFrom[i] == addressTo[i]) continue;
                return null;
            }
            return new IpAddress(Arrays.copyOf(addressFrom, length));
        }
    }
}

