/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.map.kernel;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.function.Consumer;
import ru.bitel.bgbilling.kernel.map.kernel.DefaultMapPopupMenu;
import ru.bitel.bgbilling.kernel.map.kernel.DefaultMapViewer;

public class SelectionAdapter
extends MouseAdapter {
    private boolean dragging;
    private final DefaultMapViewer viewer;
    private final Point2D startPos = new Point2D.Double();
    private final Point2D endPos = new Point2D.Double();
    private Consumer<MouseEvent> clickReaction;
    private DefaultMapPopupMenu popupMenu;

    public SelectionAdapter(DefaultMapViewer viewer) {
        this.viewer = viewer;
        this.popupMenu = new DefaultMapPopupMenu(viewer);
    }

    public void setPopupMenu(DefaultMapPopupMenu menu) {
        this.popupMenu = menu;
    }

    public DefaultMapPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void addMouseClickListener(Consumer<MouseEvent> clickReaction) {
        this.clickReaction = clickReaction;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.viewer.popupMenuIsEnable() && e.getButton() == 3 && e.getClickCount() == 1) {
            this.popupMenu.show((Component)((Object)this.viewer), e);
        }
        if (this.clickReaction != null) {
            this.clickReaction.accept(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 3) {
            return;
        }
        this.startPos.setLocation(e.getX(), e.getY());
        this.endPos.setLocation(e.getX(), e.getY());
        this.dragging = true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        this.endPos.setLocation(e.getX(), e.getY());
        this.viewer.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        if (e.getButton() != 3) {
            return;
        }
        this.viewer.repaint();
        this.dragging = false;
    }

    public Rectangle getRectangle() {
        if (this.dragging) {
            int x1 = (int)Math.min(this.startPos.getX(), this.endPos.getX());
            int y1 = (int)Math.min(this.startPos.getY(), this.endPos.getY());
            int x2 = (int)Math.max(this.startPos.getX(), this.endPos.getX());
            int y2 = (int)Math.max(this.startPos.getY(), this.endPos.getY());
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }
        return null;
    }
}

