/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.common.client.AbstractBGUPanel;

public class BGEditor
extends BGUPanel {
    private final CardLayout cardLayout;
    private final ActionListener actionListenerClose;
    private final String defaultCard;
    private String current = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>(5);
    final AbstractBGUPanel.DefaultAction actionClose = new AbstractBGUPanel.DefaultAction("close", "\u041e\u0442\u043c\u0435\u043d\u0430"){

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            BGEditor.this.actionListenerClose.actionPerformed(actionEvent);
        }
    };
    final AbstractBGUPanel.DefaultAction actionOpen = new AbstractBGUPanel.DefaultAction("open", ""){

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            BGEditor.this.show(((Component)actionEvent.getSource()).getName());
            BGEditor.this.setVisible(true);
        }
    };
    private static final Pattern actionsPattern = Pattern.compile("left(?:\\..*)?|ok(?:\\..*)?|close(?:\\..*)?|find(?:\\..*)?|clear(?:\\..*)?|item(?:\\..*)?");

    public BGEditor() {
        this((String)null);
    }

    public BGEditor(String defaultCard) {
        super(new CardLayout(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    Insets insets = parent.getInsets();
                    int ncomponents = parent.getComponentCount();
                    int w = 0;
                    int h = 0;
                    for (int i = 0; i < ncomponents; ++i) {
                        Component comp = parent.getComponent(i);
                        if (!comp.isVisible()) continue;
                        Dimension d = comp.getPreferredSize();
                        w = d.width;
                        h = d.height;
                    }
                    return new Dimension(insets.left + insets.right + w + 0, insets.top + insets.bottom + h + 0);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension minimumLayoutSize(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    Insets insets = parent.getInsets();
                    int ncomponents = parent.getComponentCount();
                    int w = 0;
                    int h = 0;
                    for (int i = 0; i < ncomponents; ++i) {
                        Component comp = parent.getComponent(i);
                        if (!comp.isVisible()) continue;
                        Dimension d = comp.getMinimumSize();
                        w = d.width;
                        h = d.height;
                    }
                    return new Dimension(insets.left + insets.right + w + 0, insets.top + insets.bottom + h + 0);
                }
            }
        });
        this.defaultCard = defaultCard;
        this.cardLayout = (CardLayout)this.getLayout();
        this.actionListenerClose = defaultCard != null ? e -> {
            this.cardLayout.show(this, defaultCard);
            this.current = defaultCard;
            this.firePropertyChange("show", this.current, this.current);
            this.firePropertyChange("edit", true, false);
        } : e -> this.setVisible(false);
        this.build();
        this.addPropertyChangeListener("edit", new PropertyChangeListener(){
            SoftReference<Component> focused = new SoftReference<Object>(null);

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == Boolean.TRUE != BGEditor.this.isEdit()) {
                    return;
                }
                if (evt.getNewValue() == Boolean.TRUE) {
                    KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    Component focused = kfm.getPermanentFocusOwner();
                    if (this.focused.get() == null || focused == null || !SwingUtilities.isDescendingFrom(focused, BGEditor.this)) {
                        this.focused = new SoftReference<Component>(kfm.getPermanentFocusOwner());
                    }
                    kfm.focusNextComponent(BGEditor.this);
                } else {
                    Component comp = this.focused.get();
                    if (comp != null) {
                        comp.requestFocus();
                    }
                }
            }
        });
        this.addPropertyChangeListener("edit", evt -> BGEditor.setActionsEnabled(this, Boolean.TRUE.equals(evt.getOldValue())));
    }

    private static void setActionsEnabled(JComponent parent, boolean enabled) {
        int size = parent.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Component comp = parent.getComponent(i);
            if (!(comp instanceof JComponent) || comp instanceof BGEditor) continue;
            JComponent c = (JComponent)comp;
            ActionMap map = c.getActionMap();
            if (map.keys() != null) {
                for (Object key : c.getActionMap().keys()) {
                    if (actionsPattern.matcher(key.toString()).matches()) continue;
                    c.getActionMap().get(key).setEnabled(enabled);
                }
            }
            BGEditor.setActionsEnabled((JComponent)comp, enabled);
        }
    }

    @Override
    protected void jbInit() {
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void addActionListener(String commandPrefix, ActionListener actionListener) {
        this.actionListeners.add(actionEvent -> {
            if (actionEvent.getActionCommand().startsWith(commandPrefix)) {
                actionListener.actionPerformed(actionEvent);
            }
        });
    }

    public void show(String name) {
        this.cardLayout.show(this, name);
        this.current = name;
        this.firePropertyChange("show", this.current, this.current);
        boolean edit = this.defaultCard == null || !this.defaultCard.equals(name);
        this.firePropertyChange("edit", !edit, edit);
    }

    public boolean isEdit() {
        if (this.defaultCard == null) {
            return this.isVisible();
        }
        return !this.defaultCard.equals(this.current);
    }

    private boolean containsKey(ActionMap map, String pattern) {
        Object[] keys = map.allKeys();
        if (keys == null) {
            return false;
        }
        for (Object key : map.allKeys()) {
            if (!((String)key).matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private JComponent prepare(JComponent component, Object constrains) {
        if (component instanceof JPanel) {
            Action actionOk;
            boolean okCanel;
            JPanel panel = (JPanel)component;
            if (panel.getActionMap() == null) {
                return null;
            }
            if (component instanceof BGUPanel) {
                ((BGUPanel)component).init();
            }
            boolean bl = okCanel = (actionOk = panel.getActionMap().get("ok")) != null || panel.getActionMap().get("close") != null;
            if (okCanel || this.containsKey(panel.getActionMap(), "left(?:\\..*)?")) {
                Object[] allKeys;
                BGEditorContainer container = new BGEditorContainer(new GridBagLayout(), component);
                container.add((Component)component, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                JPanel bottom = new JPanel(new GridBagLayout());
                if (actionOk != null) {
                    panel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 128), "ok");
                }
                if ((allKeys = panel.getActionMap().allKeys()) != null) {
                    for (Object key : allKeys) {
                        if (!(key instanceof String) || !((String)key).startsWith("left.")) continue;
                        BGButton button = new BGButton(panel.getActionMap().get(key));
                        bottom.add((Component)button, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
                    }
                }
                bottom.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                if (okCanel) {
                    Action actionClose;
                    if (actionOk != null) {
                        actionOk = new DelegateAction(actionOk, panel);
                        panel.getActionMap().put("ok", actionOk);
                    }
                    if ((actionClose = panel.getActionMap().get("close")) != null) {
                        actionClose = new DelegateAction(actionClose, panel);
                        panel.getActionMap().put("close", actionClose);
                        panel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "close");
                    } else {
                        actionClose = this.actionClose;
                        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "close");
                    }
                    BGButton buttonCancel = new BGButton(actionClose);
                    for (Object key : panel.getActionMap().allKeys()) {
                        if ("ok".equals(key) || key instanceof String && ((String)key).startsWith("ok.")) {
                            BGButton button = new BGButton(panel.getActionMap().get(key));
                            bottom.add((Component)button, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
                            continue;
                        }
                        if (!"delete".equals(key)) continue;
                        panel.getActionMap().put("delete", new DelegateAction(panel.getActionMap().get("delete"), panel));
                    }
                    bottom.add((Component)buttonCancel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
                }
                bottom.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                container.add((Component)bottom, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                component = container;
            }
            panel.getActionMap().setParent(this.getActionMap());
        }
        return component;
    }

    protected BGEditorContainer newEditorContainer(JComponent comp) {
        return new BGEditorContainer(new GridBagLayout(), comp);
    }

    protected void initBottomPanel(JPanel bottom) {
    }

    public JComponent addForm(JComponent component, Object constraints) {
        component.putClientProperty(BGEditor.class, Boolean.TRUE);
        super.add((Component)this.prepare(component, constraints), constraints != null ? constraints : "");
        if (component instanceof BGUPanel) {
            ((BGUPanel)component).build();
        }
        return component;
    }

    public JComponent addForm(JComponent component) {
        component.putClientProperty(BGEditor.class, Boolean.TRUE);
        super.add((Component)this.prepare(component, component.getName() != null ? component.getName() : ""), component.getName() != null ? component.getName() : "");
        if (component instanceof BGUPanel) {
            ((BGUPanel)component).build();
        }
        return component;
    }

    @Override
    public void setVisible(boolean flag) {
        boolean needFirePropertChange = this.isVisible() != flag;
        super.setVisible(flag);
        if (needFirePropertChange) {
            if (flag) {
                this.firePropertyChange("show", null, this.current);
                this.firePropertyChange("edit", false, true);
            } else {
                this.firePropertyChange("show", this.current, null);
                this.firePropertyChange("edit", true, false);
            }
        }
    }

    public JComponent getCurrentForm() {
        int size = this.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Component comp = this.getComponent(i);
            if (!comp.isVisible()) continue;
            if (comp instanceof BGEditorContainer) {
                return ((BGEditorContainer)comp).comp;
            }
            return (JComponent)comp;
        }
        return null;
    }

    @Override
    public boolean performAction(String action, String command) {
        return super.performAction(action, command);
    }

    @Override
    public boolean performAction(Object source, String action, String command) {
        Action a = null;
        JComponent comp = this.getCurrentForm();
        if (comp != null) {
            a = this.findAction(comp, action);
        }
        Action a2 = null;
        if (a == null) {
            comp = this;
            int size = comp.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component c = comp.getComponent(i);
                if (!(c instanceof JComponent)) continue;
                if (c instanceof BGEditorContainer) {
                    c = ((BGEditorContainer)c).comp;
                }
                if ((a = ((JComponent)c).getActionMap().get(action)) == null) continue;
                if (c.isShowing() || c.getParent() instanceof BGEditorContainer && c.getParent().getParent().getParent().isShowing()) break;
                if (a2 != null) continue;
                a2 = a;
            }
            if (a == null) {
                if (a2 == null) {
                    a = this.findAction(comp, action);
                    if (a == null) {
                        a = this.findAction(this, action);
                    }
                } else {
                    a = a2;
                }
            }
        }
        if (a != null) {
            a.actionPerformed(new ActionEvent(source != null ? source : this, 1001, command));
            return true;
        }
        return false;
    }

    protected Action findAction(JComponent comp, String action) {
        Action result = comp.getActionMap().get(action);
        if (result == null) {
            Component c;
            int i;
            ArrayList<JComponent> last = null;
            Action notShowingAction = null;
            int size = comp.getComponentCount();
            for (i = 0; i < size; ++i) {
                c = comp.getComponent(i);
                if (!(c instanceof JComponent)) continue;
                if (c instanceof BGEditor) {
                    if (last == null) {
                        last = new ArrayList<JComponent>(4);
                    }
                    last.add((JComponent)c);
                    continue;
                }
                result = this.findAction((JComponent)c, action);
                if (result == null) continue;
                if (c.isShowing() || c.getParent() instanceof BGEditorContainer && c.getParent().getParent().getParent().isShowing()) {
                    return result;
                }
                if (notShowingAction != null) continue;
                notShowingAction = result;
            }
            if (notShowingAction != null) {
                return notShowingAction;
            }
            if (last != null) {
                size = last.size();
                for (i = 0; i < size; ++i) {
                    c = (JComponent)last.get(i);
                    result = this.findAction((JComponent)c, action);
                    if (result == null) continue;
                    if (c.isShowing() || c.getParent() instanceof BGEditorContainer && c.getParent().getParent().getParent().isShowing()) {
                        return result;
                    }
                    if (notShowingAction != null) continue;
                    notShowingAction = result;
                }
            }
            return notShowingAction;
        }
        return result;
    }

    public Component getVisibleComponent() {
        for (Component comp : this.getComponents()) {
            if (!comp.isVisible()) continue;
            return comp;
        }
        return null;
    }

    class BGEditorContainer
    extends JPanel {
        private final JComponent comp;

        public BGEditorContainer(LayoutManager layout, JComponent comp) {
            super(layout);
            this.comp = comp;
        }
    }

    private class DelegateAction
    implements Action {
        final Action action;
        final JPanel editor;

        DelegateAction(Action action, JPanel editor) {
            this.action = action;
            this.editor = editor;
            action.putValue("Action.Editor", editor);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
            actionEvent.setSource(this.editor);
            for (ActionListener l : BGEditor.this.actionListeners) {
                l.actionPerformed(actionEvent);
            }
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.action.addPropertyChangeListener(listener);
        }

        @Override
        public Object getValue(String key) {
            return this.action.getValue(key);
        }

        @Override
        public boolean isEnabled() {
            return this.action.isEnabled();
        }

        @Override
        public void putValue(String key, Object value) {
            this.action.putValue(key, value);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.action.removePropertyChangeListener(listener);
        }

        @Override
        public void setEnabled(boolean b) {
            this.action.setEnabled(b);
        }
    }
}

