/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.BGSQueryLogParam;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogEntry;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleActionMap;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class BGSQueryLogDao {
    private Connection con;

    public BGSQueryLogDao(Connection con) {
        this.con = con;
    }

    public static String getTableName(Date date) {
        return ServerUtils.getMonthTableName("bgs_query_log", date);
    }

    public void log(BGSQueryLogEntry entry, Date date) throws Exception {
        String query;
        String table = BGSQueryLogDao.getTableName(date);
        if (!ServerUtils.tableExists(this.con, table)) {
            query = "CREATE TABLE " + table + "(id INT AUTO_INCREMENT NOT NULL, dtime DATETIME NOT NULL default '0000-00-00 00:00:00', uid INT NOT NULL, ip CHAR(40) NOT NULL, cid INT NOT NULL, mid_aid VARCHAR(255) NOT NULL, query TEXT NOT NULL, PRIMARY KEY id(id), KEY cid(cid), KEY dtime(dtime), KEY mid_aid(mid_aid), KEY uid(uid) )";
            ServerUtils.checkAndCreatePeriodicTableName(this.con, table, query);
        }
        query = "INSERT INTO " + table + " SET dtime=NOW(), uid=?, ip=?, cid=?, query=?, mid_aid=?";
        try (PreparedStatement psInsert = this.con.prepareStatement(query);){
            int index = 1;
            psInsert.setInt(index++, entry.getUserId());
            psInsert.setString(index++, entry.getRemoteAddr());
            psInsert.setInt(index++, entry.getContractId());
            psInsert.setString(index++, entry.getQueryString());
            psInsert.setString(index++, entry.getModuleId() + "_" + entry.getActionId());
            psInsert.executeUpdate();
        }
    }

    public void getLogTable(BGSQueryLogParam param, SearchResult<BGSQueryLogEntry> searchResult) throws Exception {
        Page page = searchResult.getPage();
        Period period = searchResult.getPeriod();
        List result = searchResult.getList();
        String tableName = BGSQueryLogDao.getTableName(period.getDateFrom());
        if (ServerUtils.tableExists(this.con, tableName)) {
            StringBuffer filterString = new StringBuffer(400);
            filterString.append(" WHERE dtime>='").append(TimeUtils.formatSQLDate((Date)period.getDateFrom()));
            filterString.append("' AND dtime<'");
            filterString.append(TimeUtils.formatSQLDate((Calendar)TimeUtils.getNextDay((Calendar)TimeUtils.convertDateToCalendar((Date)period.getDateTo()))));
            filterString.append("' ");
            if (param.getUserId() > 0 || param.getUserId() == -1) {
                filterString.append(" AND uid=").append(param.getUserId());
            }
            if (param.getContractIds() != null && !param.getContractIds().isEmpty()) {
                filterString.append(" AND cid IN ( ").append(Utils.toString(param.getContractIds())).append(" ) ");
            }
            if (param.getActionList() != null && !param.getActionList().isEmpty()) {
                filterString.append(" AND mid_aid IN ( ").append(param.getActionList().stream().map(a -> "'" + a + "'").collect(Collectors.joining(","))).append(" ) ");
            }
            if (Utils.notEmptyString((String)param.getParamName())) {
                if (!param.isRegexp()) {
                    param.setParamName(param.getParamName().replaceAll("%", "[^\n]*").replace("_", "."));
                    param.setParamValue(param.getParamValue().replaceAll("%", "[^\n]*").replace("_", "."));
                }
                filterString.append(" AND (query REGEXP '").append(param.getParamName() + " => " + param.getParamValue() + "\n'");
                filterString.append(" OR query REGEXP '").append(param.getParamName() + " => .*" + param.getParamValue() + ".*\n'");
                filterString.append(" OR query REGEXP '").append("<" + param.getParamName() + ".*>" + param.getParamValue() + "</" + param.getParamName() + ">'");
                filterString.append(" OR query REGEXP '").append(param.getParamName() + "=\\\"" + param.getParamValue() + "\\\"'");
                filterString.append(")");
            }
            String query = "SELECT SQL_CALC_FOUND_ROWS q.*, c.title AS contractTitle, u.name AS userName FROM " + tableName + " AS q LEFT JOIN contract AS c ON c.id=q.cid LEFT JOIN user AS u ON u.id=q.uid " + String.valueOf(filterString) + " ORDER BY dtime" + page.sqlLimit();
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                try (ResultSet rs = ps.executeQuery();){
                    String[] moduleTitle = new String[1];
                    ModuleActionMap actionMap = ModuleActionMap.getInstance();
                    while (rs.next()) {
                        BGSQueryLogEntry log;
                        ModuleAction action = actionMap.getModuleAction((log = this.getFromRs(rs)).getModuleId(), log.getActionId(), moduleTitle);
                        log.setActionTitle(action != null ? action.getTitle() : "???");
                        result.add(log);
                    }
                }
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
        }
    }

    private BGSQueryLogEntry getFromRs(ResultSet rs) throws SQLException {
        BGSQueryLogEntry entry = new BGSQueryLogEntry();
        entry.setDate(rs.getTimestamp("dtime"));
        entry.setUserName(Utils.maskBlank((String)rs.getString("userName"), (String)"???"));
        entry.setRemoteAddr(rs.getString("ip"));
        entry.setContractTitle(Utils.maskBlank((String)rs.getString("contractTitle"), (String)""));
        entry.setQueryString(rs.getString("query"));
        entry.setUserId(rs.getInt("uid"));
        entry.setContractId(rs.getInt("cid"));
        this.setModuleAndAction(entry, rs);
        return entry;
    }

    private void setModuleAndAction(BGSQueryLogEntry entry, ResultSet rs) throws SQLException {
        Object module = "";
        String midAid = rs.getString("mid_aid");
        String[] split = midAid.split("_");
        String id = split[0];
        String actionId = split[1];
        if (id.equals("0")) {
            module = "\u042f\u0434\u0440\u043e";
        } else if (id.startsWith("p")) {
            int pluginUID = Utils.parseInt((String)id.substring(1));
            Object pluginName = "(" + pluginUID + ")";
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPluginByUID(pluginUID);
            if (plugin != null) {
                pluginName = plugin.getName();
            }
            module = "\u041f\u043b\u0430\u0433\u0438\u043d " + (String)pluginName;
        } else {
            int moduleId = Utils.parseInt((String)id);
            BGModule bgModule = ModuleCache.getInstance().getModule(moduleId);
            module = bgModule == null ? "???" : Utils.maskBlank((String)bgModule.getTitle(), (String)"???");
        }
        entry.setModuleId(id);
        entry.setActionId(actionId);
        entry.setModuleName((String)module);
    }
}

