/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.server.util.CommandUtil;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class ScriptUtil {
    private static Logger log = LogManager.getLogger();
    GlobalConfig cfg = GlobalConfig.getGlobalConfig();

    public ScriptUtil() {
        this.init();
    }

    public void init() {
    }

    public void runStartScript(String ip, List<String> atrList) {
        try {
            Object attributes = "";
            for (String attr : atrList) {
                attributes = (String)attributes + attr + " ";
            }
            String command = this.cfg.getLoginScript() + " " + ip + " " + (String)attributes;
            this.runCommand(command);
        }
        catch (Exception ex) {
            log.error("error run start script", (Throwable)ex);
        }
    }

    private void runCommand(String command) throws IOException {
        log.info("script command: " + command);
        CommandUtil.runCommand(command);
    }

    public void runStopScript(String ip) {
        try {
            String command = this.cfg.getLogoutScript() + " " + ip;
            this.runCommand(command);
        }
        catch (Exception ex) {
            log.error("error run stop script", (Throwable)ex);
        }
    }

    public void runInitScript() {
        try {
            String command = this.cfg.getInitScript();
            this.runCommand(command);
        }
        catch (Exception ex) {
            log.error("error run init script", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Pair<Long, Long>> getIpCountInfo() throws BGException {
        HashMap<String, Pair<Long, Long>> result = new HashMap<String, Pair<Long, Long>>();
        try {
            InputStream input = null;
            InputStream errors = null;
            Process proc = null;
            String command = null;
            BufferedReader inBufReader = null;
            try {
                command = this.cfg.getIpCountScript();
                if (command == null) {
                    log.error("getIpCountInfo(): command = " + command);
                    HashMap<String, Pair<Long, Long>> hashMap = result;
                    return hashMap;
                }
                proc = Runtime.getRuntime().exec(command);
                proc.waitFor();
                errors = proc.getErrorStream();
                input = proc.getInputStream();
                InputStreamReader errReader = new InputStreamReader(errors);
                BufferedReader errBufReader = new BufferedReader(errReader);
                String str = null;
                StringBuffer errorBuf = new StringBuffer();
                while ((str = errBufReader.readLine()) != null) {
                    errorBuf.append(str);
                }
                if (errorBuf.length() > 0) {
                    log.error("Error while geting ip info: " + String.valueOf(errorBuf));
                    throw new BGException("Error in " + this.cfg.getIpCountScript());
                }
                InputStreamReader inReader = new InputStreamReader(input);
                inBufReader = new BufferedReader(inReader);
                while ((str = inBufReader.readLine()) != null) {
                    String[] subStrs = str.trim().split("\\t");
                    if (subStrs.length != 3) {
                        throw new BGException("Bad result format for " + this.cfg.getIpCountScript());
                    }
                    String ip = subStrs[0];
                    long inputBytes = Utils.parseLong((String)subStrs[1], (long)-1L);
                    long outputBytes = Utils.parseLong((String)subStrs[2], (long)-1L);
                    if (ip.matches("\\d{1,3}\\.d{1,3}\\.d{1,3}\\.d{1,3}\\.")) {
                        throw new BGException("Bad ip format in " + this.cfg.getIpCountScript());
                    }
                    if (inputBytes < 0L) throw new BGException("Bad byte format in " + this.cfg.getIpCountScript());
                    if (outputBytes < 0L) {
                        throw new BGException("Bad byte format in " + this.cfg.getIpCountScript());
                    }
                    Pair pair = new Pair((Object)inputBytes, (Object)outputBytes);
                    result.put(ip, (Pair<Long, Long>)pair);
                }
                log.debug("ips:");
                Iterator iterator = result.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    log.debug((String)entry.getKey() + ":" + String.valueOf(((Pair)entry.getValue()).getFirst()) + ":" + String.valueOf(((Pair)entry.getValue()).getSecond()));
                }
                return result;
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                return result;
            }
            finally {
                try {
                    if (proc != null) {
                        proc.destroy();
                    }
                    if (inBufReader != null) {
                        inBufReader.close();
                    }
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            throw new BGException((Throwable)e);
        }
    }
}

