/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.bean;

import bitel.billing.server.tariff.voice.bean.TableManager;
import bitel.billing.server.tariff.voice.bean.Zone;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ZoneManager {
    private Connection con;
    public final String tableName;
    private Map<Integer, String> values = null;
    private PreparedStatement getZoneIdPS = null;
    private PreparedStatement insertZonePS = null;

    public ZoneManager(Connection con, int mid) {
        this.con = con;
        this.tableName = TableManager.getTable(con, mid, "tariff_zone_");
    }

    public Map<Integer, String> getZoneTitles() {
        if (this.values == null) {
            this.values = new HashMap<Integer, String>(50);
            try {
                String query = "SELECT id, title FROM " + this.tableName;
                PreparedStatement ps = this.con.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    this.values.put(rs.getInt(1), rs.getString(2));
                }
                rs.close();
                ps.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.values;
    }

    public List<Zone> getZoneList() {
        ArrayList<Zone> result = new ArrayList<Zone>();
        try {
            String query = "SELECT id, title FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Zone zone = new Zone();
                zone.setId(rs.getInt(1));
                zone.setTitle(rs.getString(2));
                result.add(zone);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Zone getZone(int id) {
        Zone result = null;
        try {
            String query = "SELECT id, title FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = new Zone();
                result.setId(rs.getInt(1));
                result.setTitle(rs.getString(2));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getZoneId(String title) {
        int result = 0;
        try {
            if (this.getZoneIdPS == null) {
                this.getZoneIdPS = this.con.prepareStatement("SELECT id FROM " + this.tableName + " WHERE title=?");
            }
            this.getZoneIdPS.setString(1, title);
            ResultSet rs = this.getZoneIdPS.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            } else {
                rs.close();
                if (this.insertZonePS == null) {
                    this.insertZonePS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title) VALUES (?)", 1);
                }
                this.insertZonePS.setString(1, title);
                this.insertZonePS.executeUpdate();
                result = ServerUtils.lastInsertId(this.insertZonePS);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

