/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.client.UserMenuTree;
import ru.bitel.bgbilling.kernel.bgsecure.client.UserMenuUserObject;

public class UserMenuTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent component) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent component) {
        UserMenuUserObject transferable = null;
        if (component instanceof UserMenuTree) {
            DefaultMutableTreeNode treeNode;
            TreePath treePath = ((UserMenuTree)component).getSelectionPath();
            if (treePath != null && (treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null && !treeNode.isRoot()) {
                UserMenuUserObject menuUserObject = (UserMenuUserObject)treeNode.getUserObject();
                menuUserObject.setMove(true);
                transferable = menuUserObject;
            }
        } else if (component instanceof JList) {
            UserMenuUserObject menuUserObject = (UserMenuUserObject)((JList)component).getSelectedValue();
            menuUserObject.setMove(false);
            transferable = menuUserObject;
        }
        return transferable;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if ((action & 2) == 0) {
            super.exportDone(source, data, action);
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean canImport = false;
        support.setShowDropLocation(true);
        TransferHandler.DropLocation dropLocation = support.getDropLocation();
        if (dropLocation instanceof JTree.DropLocation) {
            JTree.DropLocation treeDropLocation = (JTree.DropLocation)dropLocation;
            Component component = support.getComponent();
            if (dropLocation != null && component instanceof UserMenuTree) {
                TreePath treePath = treeDropLocation.getPath();
                if (treePath != null) {
                    DefaultMutableTreeNode menuItemTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    UserMenuUserObject userObject = (UserMenuUserObject)menuItemTreeNode.getUserObject();
                    UserMenuTree tree = (UserMenuTree)component;
                    TreePath treePath2 = tree.getSelectionPath();
                    if (treePath2 != null) {
                        return ("menuBar".equals(userObject.getElement().getNodeName()) || "menu".equals(userObject.getElement().getNodeName())) && !treePath2.isDescendant(treePath);
                    }
                    return "menuBar".equals(userObject.getElement().getNodeName()) || "menu".equals(userObject.getElement().getNodeName());
                }
                canImport = true;
            }
        }
        return canImport;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        boolean result = false;
        if (this.canImport(support)) {
            UserMenuTree tree = (UserMenuTree)support.getComponent();
            JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
            TreePath dropTreePath = dropLocation.getPath();
            if (dropTreePath != null) {
                DefaultMutableTreeNode menuItemTreeNode = (DefaultMutableTreeNode)dropTreePath.getLastPathComponent();
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)tree.getModel();
                try {
                    DataFlavor[] dataFlavors = support.getTransferable().getTransferDataFlavors();
                    UserMenuUserObject userMenuUserObject = (UserMenuUserObject)support.getTransferable().getTransferData(dataFlavors[0]);
                    if (!userMenuUserObject.isMove()) {
                        DefaultMutableTreeNode aa = new DefaultMutableTreeNode();
                        aa.setUserObject(userMenuUserObject);
                        defaultTreeModel.insertNodeInto(aa, menuItemTreeNode, dropLocation.getChildIndex());
                    } else {
                        TreePath selectTreePath = tree.getSelectionPath();
                        DefaultMutableTreeNode newMenuItemTreeNode = (DefaultMutableTreeNode)selectTreePath.getLastPathComponent();
                        if (dropLocation.getChildIndex() == -1) {
                            UserMenuUserObject userObject = (UserMenuUserObject)menuItemTreeNode.getUserObject();
                            DefaultMutableTreeNode parent = menuItemTreeNode;
                            if (userObject.getElement().getNodeName().equals("item")) {
                                parent = (DefaultMutableTreeNode)menuItemTreeNode.getParent();
                            }
                            this.moveTreeNode(defaultTreeModel, newMenuItemTreeNode, parent, 0);
                        } else {
                            this.moveTreeNode(defaultTreeModel, newMenuItemTreeNode, menuItemTreeNode, dropLocation.getChildIndex());
                        }
                        tree.expandPath(new TreePath(menuItemTreeNode.getPath()));
                        tree.scrollPathToVisible(new TreePath(menuItemTreeNode.getPath()));
                        result = true;
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                tree.aa("changeData");
            }
        }
        return result;
    }

    private void moveTreeNode(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode newChild, DefaultMutableTreeNode parent, int index) {
        DefaultMutableTreeNode aa = (DefaultMutableTreeNode)newChild.clone();
        defaultTreeModel.insertNodeInto(aa, parent, index);
        for (int i = newChild.getChildCount(); i > 0; --i) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)newChild.getChildAt(i - 1);
            this.moveTreeNode(defaultTreeModel, treeNode, aa, 0);
        }
        defaultTreeModel.removeNodeFromParent(newChild);
    }
}

