/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraBrand;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostDevice;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostIntercomService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostDirectoryRuntime;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostIntercomRuntime;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostIntercomService")
public class ForpostIntercomServiceImpl
extends AbstractService
implements ForpostIntercomService {
    private ForpostManager forpostManager;

    @PostConstruct
    private void init() {
        this.forpostManager = new ForpostManager(this.moduleId);
    }

    public List<ForpostAccount> forpostIntercomAccountList() throws Exception {
        return Arrays.asList(this.forpostManager.getIntercomAccounts());
    }

    public void forpostIntercomAccountCacheReload(int accountId) throws Exception {
        ForpostIntercomRuntime forpostIntercomRuntime = ForpostIntercomRuntime.getInstance(this.moduleId);
        CompletableFuture<Void> asyncOp1 = CompletableFuture.runAsync(() -> {
            forpostIntercomRuntime.resetAccountUsers(accountId);
            forpostIntercomRuntime.getAccountUsers(accountId);
        });
        CompletableFuture<Void> asyncOp2 = CompletableFuture.runAsync(() -> {
            forpostIntercomRuntime.resetAccountCameras(accountId);
            forpostIntercomRuntime.getAccountCameras(accountId);
        });
        CompletableFuture<Void> asyncOp3 = CompletableFuture.runAsync(() -> {
            forpostIntercomRuntime.resetAccountDevices(accountId);
            forpostIntercomRuntime.getAccountDevices(accountId);
        });
        CompletableFuture<Void> asyncOp4 = CompletableFuture.runAsync(() -> {
            forpostIntercomRuntime.resetAccountHouses(accountId);
            forpostIntercomRuntime.getAccountHouses(accountId);
        });
        asyncOp1.join();
        asyncOp2.join();
        asyncOp3.join();
        asyncOp4.join();
    }

    public ForpostAccount forpostIntercomAccountDefault() throws Exception {
        return new ForpostAccount().setIsActive(this.getModuleSetup().getInt("forpost.intercom.account.IsActive", 1)).setMaxCameraCount(this.getModuleSetup().getInt("forpost.intercom.account.MaxCameraCount", 100000)).setMaxLoginCount(this.getModuleSetup().getInt("forpost.intercom.account.MaxLoginCount", 100000)).putValue("MaxCameraOnlineTranslationCount", (Object)this.getModuleSetup().getInt("forpost.intercom.account.MaxCameraOnlineTranslationCount", 100000)).putValue("MaxCameraArchivalTranslationCount", (Object)this.getModuleSetup().getInt("forpost.intercom.account.MaxCameraArchivalTranslationCount", 100000)).putValue("MaxCameraUserOnlineTranslationCount", (Object)this.getModuleSetup().getInt("forpost.intercom.account.MaxCameraUserOnlineTranslationCount", 100000)).putValue("MaxCameraUserArchivalTranslationCount", (Object)this.getModuleSetup().getInt("forpost.intercom.account.MaxCameraUserArchivalTranslationCount", 100000)).putValue("MaxSMSPerMonth", (Object)this.getModuleSetup().getInt("forpost.intercom.account.MaxSMSPerMonth", 100)).putValue("Quota", (Object)this.getModuleSetup().getInt("forpost.intercom.account.Quota", 0)).putValue("NetworkIP", (Object)this.getModuleSetup().get("forpost.intercom.account.NetworkIP", "0.0.0.0")).putValue("NetworkMask", (Object)this.getModuleSetup().get("forpost.intercom.account.NetworkIP", "0.0.0.0"));
    }

    public ForpostUser forpostIntercomUserDefault() throws Exception {
        return new ForpostUser().setIsActive(this.getModuleSetup().getInt("forpost.intercom.user.IsActive", 1)).putValue("IsReadOnly", (Object)this.getModuleSetup().getInt("forpost.intercom.user.IsReadOnly", 1)).putValue("IsAccountUserAdmin", (Object)this.getModuleSetup().getInt("forpost.intercom.user.IsAccountUserAdmin", 1)).putValue("IsAccessibleNewCameraByDefault", (Object)this.getModuleSetup().getInt("forpost.intercom.user.IsAccessibleNewCameraByDefault", 1)).putValue("IsPassAdmin", (Object)this.getModuleSetup().getInt("forpost.intercom.user.IsPassAdmin", 1)).putValue("CanChangeOwnInfo", (Object)this.getModuleSetup().getInt("forpost.intercom.user.CanChangeOwnInfo", 1)).putValue("ChangePasswordAtNextLogin", (Object)this.getModuleSetup().getInt("forpost.intercom.user.ChangePasswordAtNextLogin", 0));
    }

    public ForpostCamera forpostIntercomCameraDefault() throws Exception {
        return new ForpostCamera().setIsActive(this.getModuleSetup().getInt("forpost.intercom.camera.IsActive", 1)).setMasterId(this.getModuleSetup().getInt("forpost.intercom.camera.MasterID", 1)).setPort(this.getModuleSetup().getInt("forpost.intercom.camera.Port", 0)).putValue("CameraModelID", (Object)this.getModuleSetup().getInt("forpost.intercom.camera.CameraModelID", 0)).putValue("HTTPPort", (Object)this.getModuleSetup().getInt("forpost.intercom.camera.HTTPPort", 80)).putValue("IsSound", (Object)this.getModuleSetup().getInt("forpost.intercom.camera.IsSound", 1)).putValue("RecordType", (Object)this.getModuleSetup().getInt("forpost.intercom.camera.RecordType", 0)).putValue("MaxBandwidth", (Object)this.getModuleSetup().getInt("forpost.intercom.camera.MaxBandwidth", 1024)).putValue("Protocol", (Object)this.getModuleSetup().get("forpost.intercom.camera.Protocol", "rtsp")).putValue("RtspTransport", (Object)this.getModuleSetup().get("forpost.intercom.camera.RtspTransport", "tcp")).putValue("Quota", (Object)this.getModuleSetup().getInt("forpost.intercom.camera.RtspTransport", 0)).putValue("SyncCamera", (Object)this.getModuleSetup().getInt("forpost.intercom.camera.SyncCamera", 1)).putValue("SkipCameraCheck", (Object)this.getModuleSetup().getInt("forpost.intercom.camera.SkipCameraCheck", 1));
    }

    public ForpostDevice forpostIntercomDeviceDefault() throws Exception {
        return new ForpostDevice().setTypeId(this.getModuleSetup().getInt("forpost.intercom.device.TypeID", 1)).setSettings(this.getModuleSetup().get("forpost.intercom.device.Settings", "{\"host\":\"0.0.0.0\",\"port\":80,\"login\":\"admin\",\"password\":\"admin\"}"));
    }

    public ForpostGroup forpostIntercomHouseDefault() throws Exception {
        return new ForpostGroup();
    }

    public ForpostGroup forpostIntercomEntranceDefault() throws Exception {
        return new ForpostGroup();
    }

    public List<KeyValue> forpostIntercomManagementAccountList() throws Exception {
        ForpostAccount[] forpostAccounts = new ForpostManager(this.moduleId).getIntercomAccounts();
        return Arrays.asList(forpostAccounts).stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getName())).toList();
    }

    public List<KeyValue> forpostIntercomCameraModelList(boolean withBrand) throws Exception {
        ForpostDirectoryRuntime forpostDirectoryRuntime = ForpostDirectoryRuntime.getInstance(this.moduleId);
        Map<Integer, String> cameraBrands = forpostDirectoryRuntime.getCameraBrands().stream().collect(Collectors.toMap(Id::getId, ForpostCameraBrand::getName));
        return forpostDirectoryRuntime.getCameraModels().stream().map(a -> new KeyValue(String.valueOf(a.getId()), (String)(withBrand ? (String)((Object)cameraBrands.getOrDefault(a.getBrandId(), "??? [ID#" + a.getBrandId() + "]")) + " " : "") + a.getName())).toList();
    }

    public List<KeyValue> forpostIntercomMasterList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getMasters().stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getName())).toList();
    }

    public List<KeyValue> forpostIntercomProtocolList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getProtocols().stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getName())).toList();
    }

    public List<KeyValue> forpostIntercomRecordTypeList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getRecordTypes().stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getName())).toList();
    }

    public List<KeyValue> forpostIntercomRtspTransportList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getRtspTransports().stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getName())).toList();
    }

    public List<KeyValue> forpostIntercomDeviceTypeList(int groupId) throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getDeviceTypes().stream().filter(a -> a.getGroupId() == groupId).map(a -> new KeyValue(String.valueOf(a.getId()), a.getName() + " [ID#" + a.getId() + "]")).toList();
    }

    public List<KeyValue> forpostIntercomDeviceTypeGroupList() throws Exception {
        return Arrays.asList(new KeyValue("1", "\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u044b"), new KeyValue("2", "IP-\u0434\u043e\u043c\u043e\u0444\u043e\u043d\u044b"), new KeyValue("3", "\u0414\u043e\u043c\u043e\u0444\u043e\u043d\u043d\u044b\u0435 IP-\u0430\u0434\u0430\u043f\u0442\u0435\u0440\u044b"), new KeyValue("4", "\u0421\u0438\u0441\u0442\u0435\u043c\u044b \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043e\u043c"), new KeyValue("5", "\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435"), new KeyValue("7", "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0441 \u0434\u0438\u043d\u0430\u043c\u0438\u043a\u043e\u043c"));
    }

    public int forpostIntercomDeviceTypeGroupIdByDeviceType(int id) throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getDeviceTypes().stream().filter(a -> a.getId() == id).findFirst().map(a -> a.getGroupId()).orElse(2);
    }

    public void forpostIntercomAccountEdit(List<KeyValue> params) throws Exception {
        Objects.requireNonNull(params);
        ForpostManager forpostManager = new ForpostManager(this.moduleId);
        String id = params.stream().filter(a -> "ID".equals(a.getKey())).findFirst().map(KeyValue::getValue).orElse(null);
        if (id == null) {
            throw new BGRuntimeException("ID == null");
        }
        params.stream().filter(a -> "IsManagementAllowed".equals(a.getKey())).findFirst().ifPresentOrElse(a -> {}, () -> params.add(new KeyValue("IsManagementAllowed", "1")));
        try {
            Map<String, String> paramMap = params.stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
            if ("0".equals(id)) {
                paramMap.remove("ID");
                forpostManager.addAccount(paramMap);
            } else {
                forpostManager.editAccount(paramMap);
            }
        }
        catch (ForpostException ex) {
            throw new BGMessageException(ex.getErrorMessage());
        }
    }

    public void forpostIntercomUserEdit(List<KeyValue> params) throws Exception {
        Objects.requireNonNull(params);
        ForpostManager forpostManager = new ForpostManager(this.moduleId);
        String id = params.stream().filter(a -> "ID".equals(a.getKey())).findFirst().map(KeyValue::getValue).orElse(null);
        if (id == null) {
            throw new BGRuntimeException("ID == null");
        }
        try {
            Map<String, String> paramMap = params.stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
            if ("0".equals(id)) {
                paramMap.remove("ID");
                forpostManager.addUser(paramMap);
            } else {
                forpostManager.editUser(paramMap);
            }
            int accountId = Utils.parseInt((String)params.stream().filter(a -> "AccountID".equals(a.getKey())).findFirst().map(KeyValue::getValue).orElse("0"));
            ForpostIntercomRuntime.getInstance(this.moduleId).resetAccountUsers(accountId);
        }
        catch (ForpostException ex) {
            throw new BGMessageException(ex.getErrorMessage());
        }
    }

    public void forpostIntercomCameraEdit(List<KeyValue> params) throws Exception {
        Objects.requireNonNull(params);
        ForpostManager forpostManager = new ForpostManager(this.moduleId);
        String id = params.stream().filter(a -> "ID".equals(a.getKey())).findFirst().map(KeyValue::getValue).orElse(null);
        if (id == null) {
            throw new BGRuntimeException("ID == null");
        }
        try {
            Map<String, String> paramMap = params.stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
            if ("0".equals(id)) {
                paramMap.remove("ID");
                forpostManager.addCamera(paramMap);
            } else {
                forpostManager.editCamera(paramMap);
            }
            int accountId = Utils.parseInt((String)params.stream().filter(a -> "AccountID".equals(a.getKey())).findFirst().map(KeyValue::getValue).orElse("0"));
            ForpostIntercomRuntime.getInstance(this.moduleId).resetAccountCameras(accountId);
        }
        catch (ForpostException ex) {
            throw new BGMessageException(ex.getErrorMessage());
        }
    }

    public void forpostIntercomDeviceEdit(List<KeyValue> params) throws Exception {
        Objects.requireNonNull(params);
        ForpostManager forpostManager = new ForpostManager(this.moduleId);
        String id = params.stream().filter(a -> "ID".equals(a.getKey())).findFirst().map(KeyValue::getValue).orElse(null);
        if (id == null) {
            throw new BGRuntimeException("ID == null");
        }
        try {
            Map<String, String> paramMap = params.stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
            if ("0".equals(id)) {
                paramMap.remove("ID");
                forpostManager.addDevice(paramMap);
            } else {
                forpostManager.editDevice(paramMap);
            }
            int accountId = Utils.parseInt((String)params.stream().filter(a -> "AccountID".equals(a.getKey())).findFirst().map(KeyValue::getValue).orElse("0"));
            ForpostIntercomRuntime.getInstance(this.moduleId).resetAccountDevices(accountId);
        }
        catch (ForpostException ex) {
            throw new BGMessageException(ex.getErrorMessage());
        }
    }

    public void forpostIntercomHouseEdit(List<KeyValue> params) throws Exception {
        Objects.requireNonNull(params);
        ForpostManager forpostManager = new ForpostManager(this.moduleId);
        String id = params.stream().filter(a -> "ID".equals(a.getKey())).findFirst().map(KeyValue::getValue).orElse(null);
        if (id == null) {
            throw new BGRuntimeException("ID == null");
        }
        try {
            Map<String, String> paramMap = params.stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
            if ("0".equals(id)) {
                paramMap.remove("ID");
                forpostManager.addAccountGroup(paramMap);
            } else {
                forpostManager.editAccountGroup(paramMap);
            }
            int accountId = Utils.parseInt((String)params.stream().filter(a -> "AccountID".equals(a.getKey())).findFirst().map(KeyValue::getValue).orElse("0"));
            ForpostIntercomRuntime.getInstance(this.moduleId).resetAccountHouses(accountId);
        }
        catch (ForpostException ex) {
            throw new BGMessageException(ex.getErrorMessage());
        }
    }

    public List<IdTitle> forpostIntercomHouseList(int accountId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AccountID", String.valueOf(accountId));
        ForpostManager forpostManager = new ForpostManager(this.moduleId);
        return Arrays.asList(forpostManager.getAccountGroups(params)).stream().map(a -> new IdTitle(a.getId(), a.getName())).toList();
    }
}

