/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.ip;

import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.ip.InetServRuntimeRangeSet;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.CopyOnWriteRangeArrayMap;
import ru.bitel.common.util.Matcher;

public class InetServRuntimeAddressMap {
    private final CopyOnWriteRangeArrayMap<IpAddress, InetServRuntime, Long> addressMap = new CopyOnWriteRangeArrayMap<IpAddress, InetServRuntime, Long>(this, InetServRuntimeMap.PERIOD_RANGER, 256){

        protected InetServRuntime[] newArray(InetServRuntime r) {
            return new InetServRuntime[]{r};
        }

        protected InetServRuntime[] newArray(int size) {
            return new InetServRuntime[size];
        }
    };
    private final InetServRuntimeRangeSet rangeSet = new InetServRuntimeRangeSet();

    public void add(InetServRuntime inetServRuntime) {
        InetServ inetServ = inetServRuntime.getInetServ();
        byte[] addressFrom = inetServ.getAddressFrom();
        if (addressFrom == null) {
            return;
        }
        byte[] addressTo = inetServ.getAddressTo();
        if (addressTo == null || IpAddress.equals((byte[])addressFrom, (byte[])addressTo)) {
            this.addressMap.add((Object)new IpAddress(addressFrom), (Object)inetServRuntime);
        } else {
            this.rangeSet.add(inetServRuntime);
        }
    }

    public void remove(InetServRuntime inetServRuntime) {
        InetServ inetServ = inetServRuntime.getInetServ();
        byte[] addressFrom = inetServ.getAddressFrom();
        if (addressFrom == null) {
            return;
        }
        byte[] addressTo = inetServ.getAddressTo();
        if (addressTo == null || IpAddress.equals((byte[])addressFrom, (byte[])addressTo)) {
            this.addressMap.remove((Object)new IpAddress(addressFrom), (Object)inetServRuntime);
        } else {
            this.rangeSet.remove(inetServRuntime);
        }
    }

    public InetServRuntime get(byte[] address, long millis) {
        IpAddress ipAddress = new IpAddress(address);
        InetServRuntime result = (InetServRuntime)this.addressMap.get((Object)ipAddress, (Comparable)Long.valueOf(millis));
        if (result != null) {
            return result;
        }
        return this.rangeSet.get(ipAddress, millis);
    }

    public InetServRuntime get(byte[] address, long millis, Matcher<InetServRuntime> matcher) {
        IpAddress ipAddress = new IpAddress(address);
        InetServRuntime result = (InetServRuntime)this.addressMap.get((Object)ipAddress, (Comparable)Long.valueOf(millis), matcher);
        if (result != null) {
            return result;
        }
        return this.rangeSet.get(ipAddress, millis, matcher);
    }
}

