/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api.forpost;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraBrand;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostDeviceType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostMaster;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostProtocol;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostPtzType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRecordType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRemoteMaster;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRtspTransport;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseCameraModelsAndBrands;

public class ForpostDirectoryRuntime
extends BGLogger {
    private static ConcurrentHashMap<Integer, ForpostDirectoryRuntime> instanceMap = new ConcurrentHashMap();
    private final int moduleId;
    private ForpostManager forpostManager;
    private ForpostMaster[] forpostMasters = null;
    private ForpostPtzType[] forpostPtzTypes = null;
    private ForpostProtocol[] forpostProtocols = null;
    private ForpostRecordType[] forpostRecordTypes = null;
    private ForpostDeviceType[] forpostDeviceTypes = null;
    private ForpostCameraBrand[] forpostCameraBrands = null;
    private ForpostCameraModel[] forpostCameraModels = null;
    private ForpostRemoteMaster[] forpostRemoteMasters = null;
    private ForpostRtspTransport[] forpostRtspTransports = null;

    public static ForpostDirectoryRuntime getInstance(int moduleId) {
        ForpostDirectoryRuntime instance = instanceMap.get(moduleId);
        if (instance == null) {
            instance = new ForpostDirectoryRuntime(moduleId);
            instanceMap.put(moduleId, instance);
        }
        return instance;
    }

    private ForpostDirectoryRuntime(int moduleId) {
        this.moduleId = moduleId;
    }

    private ForpostManager getForpostManager() {
        return Optional.ofNullable(this.forpostManager).orElseGet(() -> {
            this.forpostManager = new ForpostManager(this.moduleId);
            return this.forpostManager;
        });
    }

    public List<ForpostMaster> getMasters() {
        if (this.forpostMasters == null) {
            try {
                this.forpostMasters = this.getForpostManager().getMasters();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.forpostMasters == null ? Collections.emptyList() : Arrays.asList(this.forpostMasters);
    }

    public void resetMasters() {
        this.forpostMasters = null;
    }

    public List<ForpostRemoteMaster> getRemoteMasters() {
        if (this.forpostRemoteMasters == null) {
            try {
                this.forpostRemoteMasters = this.getForpostManager().getRemoteMasters();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.forpostRemoteMasters == null ? Collections.emptyList() : Arrays.asList(this.forpostRemoteMasters);
    }

    public void resetRemoteMasters() {
        this.forpostRemoteMasters = null;
    }

    public List<ForpostProtocol> getProtocols() {
        if (this.forpostProtocols == null) {
            try {
                this.forpostProtocols = this.getForpostManager().getProtocols();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.forpostProtocols == null ? Collections.emptyList() : Arrays.asList(this.forpostProtocols);
    }

    public void resetProtocols() {
        this.forpostProtocols = null;
    }

    public List<ForpostRecordType> getRecordTypes() {
        if (this.forpostRecordTypes == null) {
            try {
                this.forpostRecordTypes = this.getForpostManager().getRecordTypes();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.forpostRecordTypes == null ? Collections.emptyList() : Arrays.asList(this.forpostRecordTypes);
    }

    public void resetRecordTypes() {
        this.forpostRecordTypes = null;
    }

    public List<ForpostDeviceType> getDeviceTypes() {
        if (this.forpostDeviceTypes == null) {
            try {
                this.forpostDeviceTypes = this.getForpostManager().getAccountDeviceType();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.forpostDeviceTypes == null ? Collections.emptyList() : Arrays.asList(this.forpostDeviceTypes);
    }

    public void resetDeviceTypes() {
        this.forpostDeviceTypes = null;
    }

    public List<ForpostCameraModel> getCameraModels() {
        if (this.forpostCameraModels == null) {
            try {
                ResponseCameraModelsAndBrands cameraModelsAndBrands = this.getForpostManager().getCameraModelsAndBrands();
                this.forpostCameraBrands = cameraModelsAndBrands.getBrands();
                this.forpostCameraModels = cameraModelsAndBrands.getModels();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.forpostCameraModels == null ? Collections.emptyList() : Arrays.asList(this.forpostCameraModels);
    }

    public void resetCameraModels() {
        this.forpostCameraModels = null;
    }

    public List<ForpostRtspTransport> getRtspTransports() {
        if (this.forpostRtspTransports == null) {
            try {
                this.forpostRtspTransports = this.getForpostManager().getRtspTransports();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.forpostRtspTransports == null ? Collections.emptyList() : Arrays.asList(this.forpostRtspTransports);
    }

    public void resetRtspTransports() {
        this.forpostRtspTransports = null;
    }

    public List<ForpostCameraBrand> getCameraBrands() {
        if (this.forpostCameraBrands == null) {
            try {
                ResponseCameraModelsAndBrands cameraModelsAndBrands = this.getForpostManager().getCameraModelsAndBrands();
                this.forpostCameraBrands = cameraModelsAndBrands.getBrands();
                this.forpostCameraModels = cameraModelsAndBrands.getModels();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.forpostCameraBrands == null ? Collections.emptyList() : Arrays.asList(this.forpostCameraBrands);
    }

    public void resetCameraBrands() {
        this.forpostCameraBrands = null;
    }

    public List<ForpostPtzType> getPtzTypes() {
        if (this.forpostPtzTypes == null) {
            try {
                this.forpostPtzTypes = this.getForpostManager().getPtzTypes();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return this.forpostPtzTypes == null ? Collections.emptyList() : Arrays.asList(this.forpostPtzTypes);
    }

    public void resetPtzTypes() {
        this.forpostPtzTypes = null;
    }
}

