/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class InetServMoveManager
implements AutoCloseable {
    private final Connection con;
    private final int moduleId;
    private final InetSessionDao sessionDao;
    private final InetServDao inetServDao;

    public InetServMoveManager(Connection con, int moduleId) throws BGException {
        this.con = con;
        this.moduleId = moduleId;
        this.sessionDao = new InetSessionDao(con, moduleId);
        this.inetServDao = new InetServDao(con, moduleId);
    }

    public void wrapSessionData(InetServ inetServ, InetServ newInetServ) throws BGException {
        try {
            Calendar calFrom = TimeUtils.convertDateToCalendar((Date)newInetServ.getDateFrom());
            Calendar calTo = TimeUtils.convertDateToCalendar((Date)newInetServ.getDateTo());
            if (calTo == null) {
                calTo = GregorianCalendar.getInstance();
            }
            String query = null;
            ResultSet rs = null;
            Calendar dateMonth = (Calendar)calFrom.clone();
            while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)calTo) >= 0) {
                String sessionAccountTable = ServerUtils.getModuleMonthTableName((String)"inet_session_log_account", (Date)dateMonth.getTime(), (int)this.moduleId);
                String sessionTable = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)dateMonth.getTime(), (int)this.moduleId);
                if (ServerUtils.tableExists((Connection)this.con, (String)sessionAccountTable) && ServerUtils.tableExists((Connection)this.con, (String)sessionTable)) {
                    StringBuilder sessionIdList = new StringBuilder(1000);
                    query = "SELECT id FROM " + sessionTable + " WHERE servId=? AND sessionStart>=?";
                    PreparedStatement psSelectSessions = this.con.prepareStatement(query);
                    psSelectSessions.setInt(1, inetServ.getId());
                    psSelectSessions.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)calFrom));
                    rs = psSelectSessions.executeQuery();
                    while (rs.next()) {
                        if (sessionIdList.length() > 0) {
                            sessionIdList.append(",");
                        }
                        sessionIdList.append(rs.getInt(1));
                    }
                    psSelectSessions.close();
                    if (sessionIdList.length() > 0) {
                        query = "UPDATE " + sessionTable + " SET servId=? WHERE id IN ( " + sessionIdList.toString() + " )";
                        PreparedStatement psUpdateLogSession = this.con.prepareStatement(query);
                        psUpdateLogSession.setInt(1, newInetServ.getId());
                        psUpdateLogSession.executeUpdate();
                        psUpdateLogSession.close();
                        query = "UPDATE " + sessionAccountTable + " SET contractId=? WHERE contractId = ? AND sessionId IN ( " + sessionIdList.toString() + " )";
                        PreparedStatement psUpdateSessionAccount = this.con.prepareStatement(query);
                        psUpdateSessionAccount.setInt(1, newInetServ.getContractId());
                        psUpdateSessionAccount.setInt(2, inetServ.getContractId());
                        psUpdateSessionAccount.executeUpdate();
                        psUpdateSessionAccount.close();
                    }
                }
                dateMonth.add(2, 1);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void moveSessionData(InetServ inetServ, InetServ newInetServ) throws BGException {
        try {
            Calendar calFrom = TimeUtils.convertDateToCalendar((Date)newInetServ.getDateFrom());
            Calendar calTo = TimeUtils.convertDateToCalendar((Date)newInetServ.getDateTo());
            if (calTo == null) {
                calTo = GregorianCalendar.getInstance();
            }
            String query = null;
            Calendar dateMonth = (Calendar)calFrom.clone();
            while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)calTo) >= 0) {
                String sessionAccountTable = ServerUtils.getModuleMonthTableName((String)"inet_session_log_account", (Date)dateMonth.getTime(), (int)this.moduleId);
                String sessionTable = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)dateMonth.getTime(), (int)this.moduleId);
                if (ServerUtils.tableExists((Connection)this.con, (String)sessionAccountTable) && ServerUtils.tableExists((Connection)this.con, (String)sessionTable)) {
                    query = "UPDATE " + sessionAccountTable + " SET contractId=? WHERE contractId = ? AND sessionId IN (  SELECT id FROM " + sessionTable + " WHERE  servId=?  )";
                    PreparedStatement psUpdateSessionAccount = this.con.prepareStatement(query);
                    psUpdateSessionAccount.setInt(1, newInetServ.getContractId());
                    psUpdateSessionAccount.setInt(2, inetServ.getContractId());
                    psUpdateSessionAccount.setInt(3, inetServ.getId());
                    psUpdateSessionAccount.executeUpdate();
                    psUpdateSessionAccount.close();
                    query = "UPDATE " + sessionTable + " SET servId=? WHERE servId = ?";
                    PreparedStatement psUpdateLogSession = this.con.prepareStatement(query);
                    psUpdateLogSession.setInt(1, newInetServ.getId());
                    psUpdateLogSession.setInt(2, inetServ.getId());
                    psUpdateLogSession.executeUpdate();
                    psUpdateLogSession.close();
                }
                dateMonth.add(2, 1);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void checkForCurrentSessions(InetServ inetServ) throws BGException, BGMessageException {
        if (inetServ.getParentId() <= 0) {
            List<InetServ> childrenServs = this.inetServDao.listChildren(inetServ.getId());
            for (InetServ child : childrenServs) {
                if (this.sessionDao.listAsLog(new ArrayList<InetServType>(), null, null, null, null, Collections.singleton(child.getId()), null, null, null, null, null, null, 0, 0, true).size() <= 0) continue;
                throw new BGMessageException("\u042d\u0442\u043e\u0442 \u0441\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d, \u0442\u0430\u043a \u043d\u0430 \u0435\u0433\u043e \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0445 \u0441\u0435\u0440\u0432\u0438\u0441\u0430\u0445  \u0435\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0441\u0435\u0441\u0441\u0438\u0438 ");
            }
            inetServ.setChildren(childrenServs);
        }
        if (this.sessionDao.listAsLog(new ArrayList<InetServType>(), null, null, null, null, Collections.singleton(inetServ.getId()), null, null, null, null, null, null, 0, 0, true).size() > 0) {
            throw new BGMessageException("\u042d\u0442\u043e\u0442 \u0441\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u043d\u0435\u043c \u0435\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0441\u0435\u0441\u0441\u0438\u0438.");
        }
    }

    @Override
    public void close() throws BGException {
        this.inetServDao.close();
    }
}

