/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.ScheduleTime;

public class SubscriptionDao {
    private static final String DISPATCH_SUBSCRIPTION = "dispatch_subscription";
    private static final String DISPATCH_SUB_CONTACT = "dispatch_subscription_contact";
    private Connection con;

    public SubscriptionDao(Connection con) {
        this.con = con;
    }

    public Subscription get(int id) throws SQLException {
        Subscription result = null;
        String query = "SELECT * FROM dispatch_subscription AS subs LEFT JOIN dispatch_dispatch ON dispatch_dispatch.id=subs.dispatch_id LEFT JOIN dispatch_sender_type ON dispatch_sender_type.id=dispatch_dispatch.sender_type_id WHERE subs.id=" + id;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result = this.getSubscriptionFromRS(new DispatchDao(this.con), rs);
            }
        }
        if (result != null) {
            HashMap<Integer, Subscription> map = new HashMap<Integer, Subscription>();
            map.put(result.getId(), result);
            this.setContactsForSubscription(map);
        }
        return result;
    }

    public List<Subscription> getList(int dispatchId, int contractId) throws SQLException {
        return this.getList(dispatchId, contractId, null);
    }

    public List<Subscription> getList(int dispatchId, int contractId, Boolean active) throws SQLException {
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        HashMap<Integer, Subscription> map = new HashMap<Integer, Subscription>();
        StringBuilder query = new StringBuilder("SELECT c.title, subs.*, dispatch_dispatch.*, dispatch_sender_type.* FROM ").append(DISPATCH_SUBSCRIPTION).append(" AS subs  LEFT JOIN dispatch_dispatch ON dispatch_dispatch.id=subs.dispatch_id  LEFT JOIN contract AS c ON subs.contract_id = c.id LEFT JOIN dispatch_sender_type ON dispatch_sender_type.id=dispatch_dispatch.sender_type_id  WHERE 1=1");
        if (dispatchId > 0) {
            query.append(" AND subs.dispatch_id=").append(dispatchId);
        }
        if (contractId > 0) {
            query.append(" AND subs.contract_id=").append(contractId);
        }
        if (active != null) {
            query.append(" AND subs.active=").append(active.toString());
            query.append(" AND (date_from IS NULL OR ?>=date_from ) AND (date_to IS NULL OR ?<=date_to)");
        }
        DispatchDao dd = new DispatchDao(this.con);
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (active != null) {
                int index = 1;
                Date dt = TimeUtils.convertDateToSqlDate((java.util.Date)new java.util.Date());
                ps.setDate(index++, dt);
                ps.setDate(index++, dt);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Subscription subscription = this.getSubscriptionFromRS(dd, rs);
                    subscription.setContractTitle(rs.getString("c.title"));
                    result.add(subscription);
                    map.put(subscription.getId(), subscription);
                }
            }
        }
        this.setContactsForSubscription(map);
        return result;
    }

    private Subscription getSubscriptionFromRS(DispatchDao dd, ResultSet rs) throws SQLException {
        Subscription subscription = new Subscription();
        subscription.setId(rs.getInt("subs.id"));
        subscription.setContractId(rs.getInt("subs.contract_id"));
        subscription.setDispatch(dd.getDispatchFromRS(rs));
        subscription.setComment(rs.getString("subs.comment"));
        subscription.setRepeatTime(ScheduleTime.deserialize((String)rs.getString("subs.repeat_time")));
        subscription.setActive(rs.getBoolean("subs.active"));
        Period period = new Period();
        period.setDateFrom(TimeUtils.convertSqlDateToDate((Date)rs.getDate("subs.date_from")));
        period.setDateTo(TimeUtils.convertSqlDateToDate((Date)rs.getDate("subs.date_to")));
        subscription.setSubscriptionPeriod(period);
        Preferences prefs = new Preferences();
        try {
            Iterable elements;
            Document doc = XMLUtils.parseDocument((byte[])rs.getBytes("subs.data"));
            if (doc != null && (elements = XMLUtils.selectElements((Node)doc, (String)"//items/item")) != null) {
                for (Element itemElement : elements) {
                    prefs.set(itemElement.getAttribute("key"), itemElement.getAttribute("value"));
                }
            }
        }
        catch (Exception ex) {
            throw new BGRuntimeException((Throwable)ex);
        }
        subscription.setPreferences(prefs);
        return subscription;
    }

    private void setContactsForSubscription(Map<Integer, Subscription> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            String query = "SELECT dispatch_contact.*, cont.subscription_id FROM dispatch_subscription_contact AS cont LEFT JOIN dispatch_contact ON dispatch_contact.id=cont.contact_id WHERE cont.subscription_id IN ( " + Utils.toString(map.keySet()) + " )";
            try (Statement st = this.con.createStatement();
                 ResultSet rs = st.executeQuery(query);){
                ContactDao contactDao = new ContactDao(this.con);
                while (rs.next()) {
                    Subscription subscription = map.get(rs.getInt("cont.subscription_id"));
                    ArrayList<Contact> contacts = subscription.getContacts();
                    if (contacts == null) {
                        contacts = new ArrayList<Contact>();
                        subscription.setContacts(contacts);
                    }
                    contacts.add(contactDao.getContactFromRS(rs));
                }
            }
        }
    }

    public void delete(int subscriptionId) throws SQLException {
        String query = "DELETE FROM dispatch_subscription WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, subscriptionId);
            ps.executeUpdate();
        }
        query = "DELETE FROM dispatch_subscription_contact WHERE subscription_id=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, subscriptionId);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void deleteByDispatch(int id) throws SQLException {
        List<Subscription> subs = this.getList(id, -1);
        if (subs.size() == 0) {
            return;
        }
        String idsString = Utils.toString((Iterable)subs.stream().map(Id::getId).collect(Collectors.toList()));
        String query = " DELETE FROM dispatch_subscription WHERE id IN (" + idsString + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
        query = "DELETE FROM dispatch_subscription_contact WHERE subscription_id IN (" + idsString + ")";
        ps = this.con.prepareStatement(query);
        try {
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public boolean isContactSubscribed(int contactId) throws SQLException {
        boolean result = false;
        String query = "SELECT contact_id FROM dispatch_subscription_contact WHERE contact_id=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contactId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = true;
                }
            }
        }
        return result;
    }

    public void update(Subscription subscription) throws SQLException {
        Document doc = XMLUtils.newDocument();
        if (doc != null) {
            Element items = XMLUtils.createElement((Document)doc, (String)"items");
            for (Map.Entry entry : subscription.getPreferences().entrySet()) {
                Element item = XMLUtils.createElement((Element)items, (String)"item");
                item.setAttribute("key", (String)entry.getKey());
                item.setAttribute("value", (String)entry.getValue());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtils.serialize((Node)doc, (OutputStream)baos, (String)"UTF-8");
            byte[] data = baos.toByteArray();
            StringBuilder query = new StringBuilder(subscription.getId() > 0 ? "UPDATE " : "INSERT INTO ").append(DISPATCH_SUBSCRIPTION).append(" SET dispatch_id=?, data=?, contract_id=?, comment=?, repeat_time=?, active=?,").append(" date_from=?, date_to=?");
            if (subscription.getId() > 0) {
                query.append(" WHERE id=").append(subscription.getId());
            }
            int index = 1;
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                ps.setInt(index++, subscription.getDispatch().getId());
                ps.setBytes(index++, data);
                ps.setInt(index++, subscription.getContractId());
                ps.setString(index++, subscription.getComment());
                ps.setString(index++, ScheduleTime.serialize((ScheduleTime)subscription.getRepeatTime()));
                ps.setBoolean(index++, subscription.isActive());
                if (subscription.getSubscriptionPeriod() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)subscription.getSubscriptionPeriod().getDateFrom()));
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)subscription.getSubscriptionPeriod().getDateTo()));
                } else {
                    ps.setDate(index++, null);
                    ps.setDate(index++, null);
                }
                ps.executeUpdate();
                if (subscription.getId() <= 0) {
                    subscription.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
            }
        }
        Object query = "DELETE FROM dispatch_subscription_contact WHERE subscription_id=" + subscription.getId();
        try (Statement st = this.con.createStatement();){
            st.executeUpdate((String)query);
        }
        query = "INSERT INTO dispatch_subscription_contact SET subscription_id=?, contact_id=?";
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            for (Contact contact : subscription.getContacts()) {
                ps.setInt(1, subscription.getId());
                ps.setInt(2, contact.getId());
                ps.executeUpdate();
            }
        }
    }

    public void deleteContractSubscriptions(int contractId) throws SQLException {
        String query = "DELETE subscription, contact FROM dispatch_subscription AS subscription INNER JOIN dispatch_subscription_contact AS contact ON subscription.id=contact.subscription_id WHERE subscription.contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }

    public Subscription deleteByHash(String hash) throws SQLException {
        Subscription subscription = this.getByHash(hash);
        String query = "DELETE FROM dispatch_subscription_contact WHERE hash=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, hash);
            ps.executeUpdate();
        }
        return this.get(subscription.getId());
    }

    public Subscription getByHash(String hashString) throws SQLException {
        Subscription result = null;
        String query = "SELECT subscription_id FROM dispatch_subscription_contact WHERE hash=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, hashString);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.get(rs.getInt("subscription_id"));
                }
            }
        }
        return result;
    }

    public void generateHashes(Subscription subscription) throws SQLException {
        String query = "UPDATE dispatch_subscription_contact SET hash=? WHERE subscription_id=? AND contact_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (Contact contact : subscription.getContacts()) {
                int index = 1;
                ps.setString(index++, Utils.getDigest((String)(subscription.getId() + String.valueOf(contact.getId())), (String)"UTF-8"));
                ps.setInt(index++, subscription.getId());
                ps.setInt(index++, contact.getId());
                ps.executeUpdate();
            }
        }
    }
}

