/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.task;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Card;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.TariffRequestManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.mail.MailTaskSynchronizer;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class Synchronizer
extends TaskBase {
    private String mail;
    private Set<Long> ignoreCard = new HashSet<Long>();
    private StringBuilder errorsLog = new StringBuilder();
    private static final int MAX_ERROR_LOG_SIZE = 4000;
    private Collection<Long> oneusercardsnumber;
    private Collection<Integer> oneusercardsid;
    private ConnectionSet connectionSet;
    private Connection con;
    private Connection conSlave;

    public void setUserCards(Collection<UserCard> oneusercards) {
        this.oneusercardsnumber = oneusercards.stream().map(uc -> uc.getNumber()).collect(Collectors.toSet());
        this.oneusercardsid = oneusercards.stream().map(uc -> uc.getId()).collect(Collectors.toSet());
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Cerbercrypt. \u0417\u0430\u0434\u0430\u0447\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0431\u0430\u0437\u044b \u0441 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435\u043c \u043d\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430\u0445. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + (String)(this.oneusercardsnumber != null ? ". \u041f\u043e \u043a\u0430\u0440\u0442\u0430\u043c: " + Utils.toString(this.oneusercardsnumber) : ". \u041f\u043e \u0432\u0441\u0435\u043c \u043a\u0430\u0440\u0442\u0430\u043c") + ".";
    }

    protected boolean initTask() {
        boolean result = true;
        this.mail = this.taskSetup.get("error.mail", null);
        List _ignoreCards = Utils.toLongList((String)this.taskSetup.get("ignore.cards", null));
        if (Utils.notEmptyCollection((Collection)_ignoreCards)) {
            this.ignoreCard.addAll(_ignoreCards);
            this.getLogger().info("Ignore by card numbers, card count: " + _ignoreCards.size());
        }
        return result;
    }

    protected void executeTask() {
        ServerContext threadContext = (ServerContext)ThreadContext.get();
        this.connectionSet = threadContext != null ? threadContext.getConnectionSet() : ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
        this.con = this.connectionSet.getConnection();
        this.conSlave = this.connectionSet.getSlaveConnection();
        try {
            this.doSynchronize();
        }
        catch (Exception e) {
            this.getLogger().error("error do synchronize", (Throwable)e);
            this.addErrorLog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438: " + e.getMessage());
        }
        finally {
            if (threadContext == null) {
                this.connectionSet.close();
            }
        }
        if (this.errorsLog.length() > 0) {
            if (Utils.notBlankString((String)this.mail)) {
                try {
                    MailData mailData = new MailTaskSynchronizer().setModuleId(this.moduleId).setRecipients(this.mail).setSubject("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 CerberCrypt (\u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u0443 alarm-\u043e\u0432, \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 mail \u0437\u0430\u0434\u0430\u0447\u0438 \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u0439)").addTextPart("text", this.errorsLog.toString());
                    new MailMsg((Preferences)this.setup).sendMessage(mailData);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            String key = "cerbercrypt.synchronizer.error";
            String subject = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 CerberCrypt";
            AlarmSender.sendAlarm((String)key, (long)0L, (String)subject, (String)this.errorsLog.toString());
        }
    }

    private void doSynchronize() throws Exception {
        HashSet<Long> allcards;
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        Calendar time = this.getOperatingTime();
        CardManager cardManager = new CardManager(this.conSlave, this.moduleId, 0);
        UserCardManager userCardManagerSlave = new UserCardManager(this.conSlave, this.moduleId, 0);
        UserCardManager userCardManagerMaste = new UserCardManager(this.con, this.moduleId, 0);
        CardPacketManager cardPacketManagerSlave = new CardPacketManager(this.conSlave, this.moduleId);
        CardPacketManager cardPacketManagerMaste = new CardPacketManager(this.con, this.moduleId);
        HashSet<Long> successfulSyncCards = new HashSet<Long>(1000);
        HashSet<Long> errorSyncCards = new HashSet<Long>(1000);
        if (this.oneusercardsnumber == null) {
            List notSynchronizedDealers;
            allcards = new HashSet<Long>(1000);
            for (Card card : cardManager.getFullCardList()) {
                allcards.add(card.getNumber());
            }
            this.getLogger().info("Full card mode, card count: " + allcards.size());
            long ignoreContractGroups = Utils.enumToMask((String)this.taskSetup.get("ignore.contract.groups", ""));
            if (ignoreContractGroups > 0L) {
                int count = 0;
                for (UserCard card : userCardManagerSlave.getListByGroups(ignoreContractGroups)) {
                    ++count;
                    this.ignoreCard.add(card.getNumber());
                }
                this.getLogger().info("Ignore by contract groups, card count: " + count);
            }
            if ((notSynchronizedDealers = moduleSetup.getIntegerList("not.synchronized.dealers", null)) != null) {
                Iterator<Object> iterator = notSynchronizedDealers.iterator();
                while (iterator.hasNext()) {
                    int dealerId = (Integer)iterator.next();
                    int count = 0;
                    for (Card card : cardManager.getCardsOfDealer(dealerId)) {
                        ++count;
                        this.ignoreCard.add(card.getNumber());
                    }
                    this.getLogger().info("Ignore by dealer id=" + dealerId + ", card count: " + count);
                }
            }
        } else {
            this.getLogger().info("Single card mode, card numbers: " + Utils.toString(this.oneusercardsnumber));
            allcards = new HashSet();
            allcards.addAll(this.oneusercardsnumber);
        }
        this.doSynchronizeMultiroomCopycards(moduleSetup, userCardManagerMaste, cardPacketManagerMaste);
        List<CardPacket> cardPackets = cardPacketManagerSlave.getActiveCardPacketList(time, this.oneusercardsid != null ? this.oneusercardsid : null);
        Map<Integer, UserCard> usercardMap = userCardManagerSlave.getUserCardMap(time, this.oneusercardsid != null ? this.oneusercardsid : null);
        try (DigitalTVServiceActivator activator = DigitalTVServiceActivator.newInstance((ParameterMap)moduleSetup, this.con, this.conSlave, this.moduleId, time);){
            int currentUserCardId = -1;
            UserCard currentUserCard = null;
            ArrayList<CardPacket> currentCardPacketList = new ArrayList<CardPacket>();
            for (CardPacket cardPacket : cardPackets) {
                if (currentUserCardId != cardPacket.getUsercardId()) {
                    if (currentUserCardId != -1) {
                        this.modify(activator, currentUserCardId, currentUserCard, currentCardPacketList, allcards, successfulSyncCards, errorSyncCards);
                    }
                    if ((currentUserCard = usercardMap.get(cardPacket.getUsercardId())) != null) {
                        currentUserCardId = currentUserCard.getId();
                        currentCardPacketList.clear();
                    } else {
                        currentUserCardId = -1;
                        currentCardPacketList.clear();
                        continue;
                    }
                }
                currentCardPacketList.add(cardPacket);
            }
            if (currentUserCardId != -1) {
                this.modify(activator, currentUserCardId, currentUserCard, currentCardPacketList, allcards, successfulSyncCards, errorSyncCards);
            }
            for (Long cardNumber : allcards) {
                if (this.ignoreCard.contains(cardNumber)) {
                    this.getLogger().info("Ignoring: " + cardNumber);
                    continue;
                }
                try {
                    UserCard userCard = userCardManagerSlave.getUserCard((long)cardNumber, time.getTime());
                    this.getLogger().info("Closing card " + cardNumber + ", active usercard: " + (String)(userCard != null ? "id=" + userCard.getId() : "none"));
                    DigitalTVServiceActivator.ServiceActivationResult result = userCard != null ? activator.cancel(userCard, cardPacketManagerSlave.getCardPacketList(userCard.getId())) : activator.cancel(cardNumber);
                    if (!result.isResult()) {
                        this.getLogger().error("error return activator.cancel: " + result.getMessage(), (Throwable)result.getNestedException());
                        this.addErrorLog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 (cancel) \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0434\u043b\u044f \u043a\u0430\u0440\u0442\u044b " + cardNumber + " : " + result.getMessage());
                        errorSyncCards.add(cardNumber);
                        continue;
                    }
                    successfulSyncCards.add(cardNumber);
                }
                catch (Exception e) {
                    this.getLogger().error("error syncronize (cancel)", (Throwable)e);
                    this.addErrorLog("\u041d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0434\u043b\u044f \u043a\u0430\u0440\u0442\u044b " + cardNumber + " : " + e.getMessage());
                    errorSyncCards.add(cardNumber);
                }
            }
            try {
                this.getLogger().debug("check synchronizer before destroy...");
                activator.checkSynchronizerBeforeDestroy();
            }
            catch (Exception e) {
                this.getLogger().error("check synchronizer before destroy detect error (all cards are marked as not-synchronized)", (Throwable)e);
                errorSyncCards.addAll(successfulSyncCards);
                successfulSyncCards.clear();
            }
        }
        this.getLogger().info("Complete, successful synchronize " + successfulSyncCards.size() + " cards, error synchronize " + errorSyncCards.size() + " cards");
        userCardManagerMaste.setSyncStatusCards(successfulSyncCards, false);
        userCardManagerMaste.setSyncStatusCards(errorSyncCards, true);
    }

    private void modify(DigitalTVServiceActivator activator, int usercardId, UserCard usercard, List<CardPacket> cardPacketList, Set<Long> allcards, Set<Long> successfulSyncCards, Set<Long> errorSyncCards) {
        if (usercard == null) {
            this.getLogger().info("Not found active usercard with id=" + usercardId);
        } else {
            if (this.ignoreCard.contains(usercard.getNumber())) {
                this.getLogger().info("Ignoring: " + usercard.getNumber());
                return;
            }
            this.getLogger().info("Modify card " + usercard.getNumber() + ", active usercard: id=" + usercard.getId());
            allcards.remove(usercard.getNumber());
            DigitalTVServiceActivator.ServiceActivationResult result = activator.modify(usercard, cardPacketList);
            if (!result.isResult()) {
                this.getLogger().error("error return activator.modify: " + result.getMessage(), (Throwable)result.getNestedException());
                this.addErrorLog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 (modify) \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0434\u043b\u044f \u043a\u0430\u0440\u0442\u044b " + usercard.getNumber() + " : " + result.getMessage());
                errorSyncCards.add(usercard.getNumber());
            } else {
                successfulSyncCards.add(usercard.getNumber());
            }
        }
    }

    private void addErrorLog(String error) {
        if (this.errorsLog.length() < 4000) {
            this.errorsLog.append(error).append("\n");
        }
    }

    private void doSynchronizeMultiroomCopycards(ModuleSetup moduleSetup, UserCardManager userCardManager, CardPacketManager cardPacketManager) throws Exception {
        TariffRequestManager tariffRequestManager = new TariffRequestManager(this.connectionSet, this.moduleId);
        this.getLogger().debug("do synchronize multiroom-copycards...");
        Map<Integer, UserCard> userCardMap = null;
        if (this.oneusercardsid == null) {
            userCardMap = userCardManager.getUserCardMap();
        } else {
            userCardMap = new HashMap<Integer, UserCard>();
            Iterator<Object> iterator = this.oneusercardsid.iterator();
            while (iterator.hasNext()) {
                int oneusercard_id = (Integer)iterator.next();
                UserCard oneusercard = (UserCard)userCardManager.get(oneusercard_id);
                if (oneusercard != null) {
                    userCardMap.put(oneusercard.getId(), oneusercard);
                    continue;
                }
                this.getLogger().debug("warning: usercard id=" + oneusercard_id + " (oneusercard) not found (was deleted?)");
            }
        }
        for (UserCard usercard : userCardMap.values()) {
            if (usercard.getBasecardId() <= 0) continue;
            if (TimeUtils.dateInRange((Date)new Date(), (Date)usercard.getDate1(), (Date)usercard.getDate2())) {
                UserCard basecard;
                this.getLogger().debug("active usercard '" + usercard.getGuiTitle() + "' is copy of usercard id=" + usercard.getBasecardId());
                UserCard userCard = basecard = this.oneusercardsid == null ? userCardMap.get(usercard.getBasecardId()) : (UserCard)userCardManager.get(usercard.getBasecardId());
                if (basecard == null) {
                    this.getLogger().debug("error: usercard id=" + usercard.getBasecardId() + " (basecard) not found!");
                    continue;
                }
                Set<Integer> ignorePackets = tariffRequestManager.getMultiroomIgnorePacket((ParameterMap)moduleSetup, usercard.getContractId(), this.getOperatingTime());
                cardPacketManager.synchronizeCardPacketFromTo(usercard.getBasecardId(), usercard.getId(), ignorePackets, null);
                continue;
            }
            this.getLogger().debug("Inactive usercard '" + usercard.getGuiTitle() + "' is copy of usercard id=" + usercard.getBasecardId() + ", ignore!");
        }
    }

    public List<TaskParameter> taskParameters() {
        ArrayList<TaskParameter> taskParameters = new ArrayList<TaskParameter>();
        taskParameters.add(new TaskParameter().setKey("ignore.contract.groups").setTitle("ignore.contract.groups").setDefaultValue(""));
        taskParameters.add(new TaskParameter().setKey("error.mail").setTitle("error.mail").setDefaultValue(""));
        taskParameters.add(new TaskParameter().setKey("ignore.cards").setTitle("\u043a\u0430\u0440\u0442\u044b \u0438\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 ignore.cards, \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0435 \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u044b\u0435").setDefaultValue(""));
        return taskParameters;
    }
}

