/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.idealer.findbean;

import bitel.billing.server.contract.bean.find.SearchContracts;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.card.server.idealer.Conf;
import ru.bitel.bgbilling.modules.card.server.idealer.findbean.AllowFilter;
import ru.bitel.bgbilling.modules.card.server.idealer.findbean.Find;
import ru.bitel.common.Utils;

public class FindContractUtils {
    public static List<Contract> findContract(Connection con, Conf conf, long findmodes, long allowcontracts, long allowcontractsMode, HttpServletRequest request, boolean accurate) {
        List<Object> result = new ArrayList<Contract>();
        Map<String, String> searchParameters = FindContractUtils.getSearchParametersMap(conf, findmodes, allowcontracts, allowcontractsMode, request, accurate);
        if (searchParameters == null) {
            return result;
        }
        String searchString = searchParameters.get("_string");
        StringTokenizer st = new StringTokenizer(searchString, "\n");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String[] tokens = list.toArray(new String[0]);
        StringBuilder sb = new StringBuilder();
        SearchContracts searcher = new SearchContracts(searchParameters);
        result = searcher.findContract(con, (Calendar)new GregorianCalendar(), tokens, sb);
        return result;
    }

    public static Map<String, String> getSearchParametersMap(Conf conf, long findmodes, long allowcontracts, long allowcontractsMode, HttpServletRequest request, boolean _accurate) {
        HashMap<String, String> result = null;
        Object searchString = "";
        List<AllowFilter> filters = FindContractUtils.getFilters(conf, allowcontracts, allowcontractsMode);
        boolean accurate = _accurate || "true".equals(request.getParameter("accurate"));
        int num = 0;
        for (AllowFilter filter : filters) {
            long findmodesIn = findmodes;
            findmodesIn >>= 1;
            int id = 0;
            while (findmodesIn != 0L && id < conf.finders.length) {
                if ((findmodesIn & 1L) > 0L) {
                    Find find = conf.finders[id];
                    String searchPart = find.getValue(id + 1, request);
                    if (searchPart == null || searchPart.trim().isEmpty()) {
                        ++id;
                        findmodesIn >>= 1;
                        continue;
                    }
                    if (result == null) {
                        result = new HashMap<String, String>();
                    }
                    String findMode = find.mode;
                    result.put(++num + ".type", findMode);
                    result.put(num + ".regime", accurate ? "1" : "2");
                    result.put(num + ".pos", "" + num);
                    result.put(num + ".pid", (String)(find.pid > 0 ? "" + find.pid : ""));
                    result.put(num + ".mid", (String)(find.mid > 0 ? "" + find.mid : ""));
                    result.put(num + ".replace", !accurate ? ".*=>%$0%" : "");
                    if (!Utils.isEmptyString((String)filter.getGroup())) {
                        result.put(num + ".groups", filter.getGroup().trim());
                    }
                    result.put(num + ".pattern", filter.getRegexp());
                    searchString = (String)searchString + find.getValue(id + 1, request) + "\n";
                    result.put(num + ".no.contract.period.check", find.periodCheck ? "1" : "0");
                }
                ++id;
                findmodesIn >>= 1;
            }
        }
        if (result != null) {
            result.put("_string", (String)searchString);
        }
        return result;
    }

    private static List<AllowFilter> getFilters(Conf conf, long allowcontracts, long allowcontractsMode) {
        allowcontracts >>= 1;
        ArrayList<AllowFilter> filters = new ArrayList<AllowFilter>();
        if (allowcontractsMode > 0L) {
            long allow = allowcontracts;
            for (AllowFilter item : conf.allowFilters) {
                if ((allow & 1L) > 0L) {
                    filters.add(item);
                }
                allow >>= 1;
            }
        } else {
            Object regexp = "";
            Object group = "";
            boolean first = true;
            long allow = allowcontracts;
            for (AllowFilter item : conf.allowFilters) {
                if ((allow & 1L) > 0L) {
                    if (!Utils.isEmptyString((String)item.getGroup())) {
                        if (!((String)group).isEmpty()) {
                            group = (String)group + ",";
                        }
                        group = (String)group + item.getGroup();
                    }
                    if (!Utils.isEmptyString((String)item.getRegexp())) {
                        if (!first) {
                            regexp = (String)regexp + "|";
                        }
                        regexp = (String)regexp + item.getRegexp();
                        first = false;
                    }
                }
                allow >>= 1;
            }
            AllowFilter filter = new AllowFilter((String)regexp, (String)group);
            filters.add(filter);
        }
        return filters;
    }
}

