package ru.bitel.bgbilling.modules.inet.dyn.device.redback;

import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivator;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;

/**
 * Основная реализация в SmartEdgeServiceActivator.<br>
 * Различия в параметрах конфигурации по умолчанию для SmartEdgeClipsServiceActivator и SmartEdgeServiceActivator.
 * @see SmartEdgeServiceActivator
 * @author amir
 *
 */
public class SmartEdgeClipsServiceActivator
    extends SmartEdgeServiceActivator
    implements ServiceActivator
{
	public SmartEdgeClipsServiceActivator()
	{
		// параметры по умолчанию
		super(
			   false, // defaultWithoutBreak - сбрасываем соединение при переключении состояния, чтобы переполучить IP-адрес
			   CLOSE_MODE_NONE, // defaultCloseMode - не посылаем PoD при необходимости сбросить соединение
			   CLOSE_MODE_NONE, // defaultCloseEnableMode - не посылаем PoD пакет при необходимости сбросить соединение при переключении из состояния отключен во включен (при withoutBreak=false)
			   false, // defaultCloseEnableMode - по умолчанию не включаем сервисы при необходимости переключить из состояния отключен во включен (при withoutBreak=false)
			   true, // defaultDisableServicesOnClose - по умолчанию отключаем сервисы когда нужно сбросить соединение
			   true // defaultCloseRemoveFromKeyMap - по умолчанию выдаем NAK, когда нужно сбросить соединение
		);
	}

	@Override
	public Object init( Setup setup, int moduleId, InetDevice device, InetDeviceType deviceType, ParameterMap deviceConfig )
	    throws Exception
	{
		super.init( setup, moduleId, device, deviceType, deviceConfig );

		return null;
	}
}