/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;

public abstract class InetConnectionKeyMap<D, E> {
    private static final Logger logger = LogManager.getLogger();
    private ConcurrentMap<String, E> connectionMap = new ConcurrentHashMap<String, E>();
    private volatile Set<Integer> keyDeviceTypeIds;
    protected final InetApplication application;
    protected final boolean newSearch;
    private static final Pattern macrosPattern = Pattern.compile("\\$\\w+");

    protected E put(String key, E entry) {
        return this.connectionMap.put(key, entry);
    }

    protected void remove(String key, E entry) {
        this.connectionMap.remove(key, entry);
    }

    private String getKey(D device, StringBuffer sb, int servSearchMode, int deviceId, int agentDeviceId, InetServ inetServ, InetServ parentInetServ, String mac, byte[] address) {
        if (parentInetServ == null) {
            InetServRuntime inetServRuntime = this.application.getInetServRuntimeMap().get(inetServ.getId());
            InetServRuntime parentInetServRuntime = inetServRuntime.getRootInetServRuntime(this.application);
            parentInetServ = parentInetServRuntime.getInetServ();
        }
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = parentInetServ.getInterfaceId();
                if (interfaceId != -1) {
                    return this.getKey(device, sb, deviceId, agentDeviceId, interfaceId, mac, address);
                }
                logger.info("interfaceId not set");
                return null;
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = parentInetServ.getVlan();
                if (vlanId != -1) {
                    return this.getKey(device, sb, deviceId, agentDeviceId, vlanId, mac, address);
                }
                logger.info("vlanId not set");
                return null;
            }
        }
        return this.getKey(device, sb, deviceId, agentDeviceId, 0, mac, address);
    }

    protected String getKey(D device, StringBuffer sb, int deviceId, int agentDeviceId, int circuitId, String mac, byte[] address) {
        String dhcpKeyPattern = this.getPattern(device);
        Matcher m = macrosPattern.matcher(dhcpKeyPattern);
        while (m.find()) {
            String param = m.group();
            if ("$deviceId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(deviceId));
                continue;
            }
            if ("$remoteId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(agentDeviceId));
                continue;
            }
            if ("$circuitId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(circuitId));
                continue;
            }
            if ("$mac".equals(param)) {
                m.appendReplacement(sb, mac.toUpperCase());
                continue;
            }
            if ("$ip".equals(param)) {
                m.appendReplacement(sb, IpAddress.toString((byte[])address));
                continue;
            }
            logger.error("Unknown parameter in pattern: " + dhcpKeyPattern);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public InetConnectionKeyMap(InetApplication application, final boolean newSearch) throws BGException {
        this.application = application;
        this.newSearch = newSearch;
        EventProcessor.getInstance().addListener((EventListener)new EventListener<InetRadiusProcessor.AuthAcceptEvent>(){

            public void notify(InetRadiusProcessor.AuthAcceptEvent e, EventListenerContext ctx) throws BGException {
                int deviceId = e.getDeviceId();
                Object device = InetConnectionKeyMap.this.getDevice(deviceId);
                if (InetConnectionKeyMap.this.keyDeviceTypeIds != null && InetConnectionKeyMap.this.keyDeviceTypeIds.contains(InetConnectionKeyMap.this.getDeviceTypeId(device))) {
                    return;
                }
                RadiusPacket request = e.getRequest();
                RadiusPacket response = e.getResponse();
                byte[] address = response.getByteAttribute(-1, 8, null);
                if (address == null) {
                    address = request.getByteAttribute(2352, 132, null);
                }
                String userName = request.getStringAttribute(-1, 1, null);
                String callingStationId = request.getStringAttribute(-1, 31, null);
                int servSearchMode = InetConnectionKeyMap.this.getServSearchMode(device);
                if (newSearch || device != null && servSearchMode != 0) {
                    String key = InetConnectionKeyMap.this.getKey(device, new StringBuffer(48), servSearchMode, deviceId, e.getAgentDeviceId(), e.getInetServ(), null, callingStationId, address);
                    if (key != null) {
                        logger.info("Put auth accept " + key);
                        InetConnectionKeyMap.this.put(key, InetConnectionKeyMap.this.newEntry(e.getIpResourceId(), address, e.getInetServ().getId(), 0L));
                    }
                } else if (Utils.notBlankString((String)userName) && Utils.notBlankString((String)callingStationId) && address != null) {
                    String key = InetConnectionKeyMap.this.getKeyOld(deviceId, userName, callingStationId);
                    if (key != null) {
                        logger.info("Put auth accept " + key);
                        InetConnectionKeyMap.this.put(key, InetConnectionKeyMap.this.newEntry(e.getIpResourceId(), address, e.getInetServ().getId(), 0L));
                    }
                } else {
                    logger.info("Skip userName: " + userName);
                }
            }
        }, InetRadiusProcessor.AuthAcceptEvent.class);
        if (application instanceof Access) {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionAddEvent>(){

                public void notify(InetConnectionManager.ConnectionAddEvent e, EventListenerContext ctx) throws BGException {
                    InetConnectionKeyMap.this.connectionAdd(e.getInetConnection());
                }
            }, InetConnectionManager.ConnectionAddEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionUpdateEvent>(){

                public void notify(InetConnectionManager.ConnectionUpdateEvent e, EventListenerContext ctx) throws BGException {
                    InetConnectionKeyMap.this.connectionUpdate(e.getInetConnection());
                }
            }, InetConnectionManager.ConnectionUpdateEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionRemoveEvent>(){

                public void notify(InetConnectionManager.ConnectionRemoveEvent e, EventListenerContext ctx) throws BGException {
                    InetConnectionKeyMap.this.connectionRemove(e.getInetConnection());
                }
            }, InetConnectionManager.ConnectionRemoveEvent.class);
        } else {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<Accounting.ConnectionAddEvent>(){

                public void notify(Accounting.ConnectionAddEvent e, EventListenerContext ctx) throws BGException {
                    InetConnectionKeyMap.this.connectionAdd(e.getConnection());
                }
            }, Accounting.ConnectionAddEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<Accounting.ConnectionUpdateEvent>(){

                public void notify(Accounting.ConnectionUpdateEvent e, EventListenerContext ctx) throws BGException {
                    InetConnectionKeyMap.this.connectionUpdate(e.getConnection());
                }
            }, Accounting.ConnectionUpdateEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<Accounting.ConnectionRemoveEvent>(){

                public void notify(Accounting.ConnectionRemoveEvent e, EventListenerContext ctx) throws BGException {
                    InetConnectionKeyMap.this.connectionRemove(e.getConnection());
                }
            }, Accounting.ConnectionRemoveEvent.class);
        }
    }

    private void connectionAdd(InetConnection con) {
        int deviceId = con.getDeviceId();
        D device = this.getDevice(deviceId);
        if (this.keyDeviceTypeIds != null && this.keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) {
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            String key;
            InetServRuntime servRuntime = this.application.getInetServRuntimeMap().get(con.getServId());
            if (servRuntime != null && (key = this.getKey(device, new StringBuffer(48), servSearchMode, deviceId, con.getAgentDeviceId(), servRuntime.getInetServ(), servRuntime.getRootInetServRuntime(this.application).getInetServ(), con.getCallingStationId(), con.getInetAddressBytes())) != null) {
                if (con.getInetAddressBytes() != null) {
                    logger.info("Put connection add " + key);
                    this.put(key, this.newEntry(con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId()));
                } else {
                    logger.info("Ip is null " + key);
                }
            }
        } else {
            String key = this.getKeyOld(con);
            if (key != null) {
                if (con.getInetAddressBytes() != null) {
                    logger.info("Put connection add " + key);
                    this.put(key, this.newEntry(con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId()));
                } else {
                    logger.info("Ip is null " + key);
                }
            }
        }
    }

    private void connectionUpdate(InetConnection con) {
        int deviceId = con.getDeviceId();
        D device = this.getDevice(deviceId);
        if (this.keyDeviceTypeIds != null && this.keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) {
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            InetServRuntime servRuntime = this.application.getInetServRuntimeMap().get(con.getServId());
            if (servRuntime == null) {
                return;
            }
            String key = this.getKey(device, new StringBuffer(48), servSearchMode, deviceId, con.getAgentDeviceId(), servRuntime.getInetServ(), servRuntime.getRootInetServRuntime(this.application).getInetServ(), con.getCallingStationId(), con.getInetAddressBytes());
            if (key == null) {
                return;
            }
            if (con.getInetAddressBytes() != null) {
                logger.info("Put connection update " + key);
                this.put(key, this.newEntry(con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId()));
            } else {
                logger.info("Ip is null " + key);
            }
        } else {
            String key = this.getKeyOld(con);
            if (key != null) {
                if (con.getInetAddressBytes() != null) {
                    logger.info("Put connection update " + key);
                    this.put(key, this.newEntry(con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId()));
                } else {
                    logger.info("Ip is null " + key);
                }
            }
        }
    }

    private void connectionRemove(InetConnection con) {
        int deviceId = con.getDeviceId();
        D device = this.getDevice(deviceId);
        if (this.keyDeviceTypeIds != null && this.keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) {
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            InetServRuntime servRuntime = this.application.getInetServRuntimeMap().get(con.getServId());
            if (servRuntime == null) {
                return;
            }
            String key = this.getKey(device, new StringBuffer(48), servSearchMode, deviceId, con.getAgentDeviceId(), servRuntime.getInetServ(), servRuntime.getRootInetServRuntime(this.application).getInetServ(), con.getCallingStationId(), con.getInetAddressBytes());
            if (key == null) {
                return;
            }
            logger.info("Remove connection remove " + key);
            Object entry = this.connectionMap.get(key);
            if (entry != null && this.getConnectionId(entry) == con.getId()) {
                this.remove(key, entry);
            }
        } else {
            String key = this.getKeyOld(con);
            if (key != null) {
                logger.info("Remove connection remove " + key);
                Object entry = this.connectionMap.get(key);
                if (entry != null && this.getConnectionId(entry) == con.getId()) {
                    this.remove(key, entry);
                }
            }
        }
    }

    public void load(Set<Integer> keyDeviceTypeIds) {
        logger.info("Restore connections on InetConnectionKeyMap");
        this.keyDeviceTypeIds = keyDeviceTypeIds;
        InetServRuntimeMap inetServRuntimeMap = this.application.getInetServRuntimeMap();
        StringBuffer sb = new StringBuffer();
        if (this.application instanceof Access) {
            for (Map.Entry<Integer, ConcurrentMap<Long, InetConnectionRuntime>> me : ((Access)this.application).connectionManager.deviceConnectionEntrySet()) {
                Integer deviceId = me.getKey();
                ConcurrentMap<Long, InetConnectionRuntime> map = me.getValue();
                D device = this.getDevice(deviceId);
                if (keyDeviceTypeIds != null && keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) continue;
                for (InetConnectionRuntime connectionRuntime : map.values()) {
                    try {
                        this.put(inetServRuntimeMap, device, deviceId, connectionRuntime.connection, sb);
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        } else {
            for (Map.Entry<Long, InetConnectionCallRuntime> me : ((Accounting)this.application).connectionMapCall.getSessionMap().entrySet()) {
                InetConnectionCallRuntime connectionCallRuntime = me.getValue();
                InetConnection connection = connectionCallRuntime.connection;
                Integer deviceId = connection.getDeviceId();
                D device = this.getDevice(deviceId);
                if (keyDeviceTypeIds != null && keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) continue;
                try {
                    this.put(inetServRuntimeMap, device, deviceId, connection, sb);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void put(InetServRuntimeMap inetServRuntimeMap, D device, int deviceId, InetConnection connection, StringBuffer sb) {
        String key;
        Integer inetServId = connection.getServId();
        InetServRuntime inetServRuntime = inetServRuntimeMap.get(inetServId);
        if (inetServRuntime == null) {
            logger.error("InetServRuntime not found with id=" + inetServId);
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            sb.setLength(0);
            InetServRuntime rootServRuntime = inetServRuntime.getRootInetServRuntime(this.application);
            if (rootServRuntime == null) {
                logger.error("Root inetServRuntime not found for id=" + inetServId);
                return;
            }
            key = this.getKey(device, sb, servSearchMode, deviceId, connection.getAgentDeviceId(), inetServRuntime.getInetServ(), rootServRuntime.getInetServ(), connection.getCallingStationId(), connection.getInetAddressBytes());
        } else {
            key = this.getKeyOld(connection);
        }
        if (key != null) {
            logger.info("Restored connection add " + key);
            this.put(key, this.newEntry(connection.getIpResourceId(), connection.getInetAddressBytes(), connection.getServId(), connection.getId()));
        }
    }

    private String getKeyOld(InetConnection con) {
        int deviceId = con.getDeviceId();
        String userName = Utils.maskBlank((String)con.getUsername(), (String)"").toUpperCase();
        String callingStationId = con.getCallingStationId();
        return this.getKeyOld(deviceId, userName, callingStationId);
    }

    private String getKeyOld(int deviceId, String userName, String callingStationId) {
        String[] remote_circuit = userName.toUpperCase().replaceAll("[#_\\-\\|]", ":").split(":");
        if (remote_circuit.length != 2) {
            logger.error("Incorrect userName: " + userName);
            return null;
        }
        String mac = Utils.maskBlank((String)callingStationId, (String)"").toUpperCase().replaceAll("\\.", "");
        return this.getKeyOld(deviceId, remote_circuit[0], remote_circuit[1], mac);
    }

    protected String getKeyOld(int deviceId, String remoteId, String circuitId, String mac) {
        D device = this.getDevice(deviceId);
        String pattern = this.getPattern(device);
        StringBuffer sb = new StringBuffer(48);
        Matcher m = macrosPattern.matcher(pattern);
        while (m.find()) {
            String param = m.group();
            if ("$deviceId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(deviceId));
                continue;
            }
            if ("$remoteId".equals(param)) {
                m.appendReplacement(sb, remoteId);
                continue;
            }
            if ("$circuitId".equals(param)) {
                m.appendReplacement(sb, circuitId);
                continue;
            }
            if ("$mac".equals(param)) {
                m.appendReplacement(sb, mac);
                continue;
            }
            logger.error("Unknown parameter in pattern: " + pattern);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected abstract E newEntry(int var1, byte[] var2, int var3, long var4);

    protected abstract int getServSearchMode(D var1);

    protected abstract long getConnectionId(E var1);

    protected abstract D getDevice(int var1);

    protected abstract String getPattern(D var1);

    protected abstract int getDeviceTypeId(D var1);

    private String getKey(D device, StringBuffer sb, int servSearchMode, int deviceId, int agentDeviceId, InetDeviceRuntime deviceRuntime, DhcpPacket request, String mac, byte[] address) {
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = deviceRuntime.getOption82InterfaceId(request);
                return this.getKey(device, sb, deviceId, agentDeviceId, interfaceId, mac, address);
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = deviceRuntime.getOption82VlanId(request);
                return this.getKey(device, sb, deviceId, agentDeviceId, vlanId, mac, address);
            }
        }
        return null;
    }

    public E get(InetDeviceRuntime deviceRuntime, D device, DhcpPacket request) {
        String key;
        int servSearchMode = this.getServSearchMode(device);
        if (servSearchMode == 0) {
            String circuitId = Utils.bytesToHexString((byte[])request.getSubOption((byte)1).value);
            String remoteId = Utils.bytesToHexString((byte[])request.getSubOption((byte)2).value);
            String macString = Utils.bytesToHexString((byte[])request.chaddr);
            int agentDeviceId = deviceRuntime.inetDeviceId;
            key = this.getKeyOld(deviceRuntime.inetDeviceId, remoteId, circuitId, macString);
        } else {
            int agentDeviceId;
            InetDeviceRuntime agentDeviceRuntime = null;
            Object agentRemoteId = deviceRuntime.getOption82AgentRemoteId(request);
            if (agentRemoteId != null && !"".equals(agentRemoteId)) {
                agentDeviceRuntime = this.application.deviceMap.getByIdentifier(deviceRuntime, agentRemoteId);
            }
            if (agentDeviceRuntime != null) {
                agentDeviceId = agentDeviceRuntime.inetDeviceId;
            } else {
                agentDeviceId = deviceRuntime.inetDeviceId;
                agentDeviceRuntime = deviceRuntime;
            }
            String macString = Utils.bytesToString((byte[])request.chaddr, (boolean)true, null);
            key = this.getKey(device, new StringBuffer(48), servSearchMode, (int)deviceRuntime.inetDeviceId, agentDeviceId, agentDeviceRuntime, request, macString, null);
        }
        return (E)this.connectionMap.get(key);
    }

    private String getKey(D device, StringBuffer sb, int servSearchMode, int deviceId, int agentDeviceId, InetDeviceRuntime deviceRuntime, RadiusPacket request, String mac, byte[] address) {
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = deviceRuntime.getOption82InterfaceId(request);
                return this.getKey(device, sb, deviceId, agentDeviceId, interfaceId, mac, address);
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = deviceRuntime.getOption82VlanId(request);
                return this.getKey(device, sb, deviceId, agentDeviceId, vlanId, mac, address);
            }
        }
        return null;
    }

    public E get(String key) {
        return (E)this.connectionMap.get(key);
    }

    public E get(RadiusListenerWorker<?> req, InetDeviceRuntime deviceRuntime, D device, InetDeviceRuntime agentDeviceRuntime, RadiusPacket request, String macString) {
        int agentDeviceId;
        int servSearchMode = this.getServSearchMode(device);
        if (agentDeviceRuntime != null) {
            agentDeviceId = agentDeviceRuntime.inetDeviceId;
        } else {
            agentDeviceId = deviceRuntime.inetDeviceId;
            agentDeviceRuntime = deviceRuntime;
        }
        String key = this.getKey(device, new StringBuffer(48), servSearchMode, (int)deviceRuntime.inetDeviceId, agentDeviceId, agentDeviceRuntime, request, macString, null);
        return (E)this.connectionMap.get(key);
    }
}

